package jp.co.sra.jun.vrml.field.sf;

import jp.co.sra.smalltalk.StSymbol;

/**
 * JunVrmlSFBoolField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSFBoolField.java,v 8.11 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlSFBoolField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlSFField {
	protected boolean value;

	/**
	 * Create a JunVrmlSFBoolField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlSFBoolField(Object anObject) {
		this((StSymbol) anObject);
	}

	/**
	 * Create a new instance of JunVrmlSFBoolField and initialize it.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 */
	public JunVrmlSFBoolField(StSymbol aSymbol) {
		super();
		this.value_(aSymbol == $("TRUE"));
	}

	/**
	 * Create a new instance of JunVrmlSFBoolField and initialize it.
	 * 
	 * @param booleanValue boolean
	 */
	public JunVrmlSFBoolField(boolean booleanValue) {
		super();
		this.value_(booleanValue);
	}

	/**
	 * Answer my value.
	 * 
	 * @return boolean
	 */
	public boolean value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param booleanValue boolean
	 */
	public void value_(boolean booleanValue) {
		value = booleanValue;
	}
}
