package jp.co.sra.jun.vrml.field.mf;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;

/**
 * JunVrmlMFVec3fField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMFVec3fField.java,v 8.11 2008/02/20 06:33:15 nisinaka Exp $
 */
public class JunVrmlMFVec3fField extends jp.co.sra.jun.vrml.field.abstracts.JunVrmlMFField {
	protected float[] value;

	/**
	 * Create a new instance of JunVrmlMFVec3field and initialize it.
	 * 
	 * @param numbers float[]
	 */
	public JunVrmlMFVec3fField(float[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlMFVec3fField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlMFVec3fField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlMFVec3fField and initialize it.
	 * 
	 * @param aVector java.utilVector
	 */
	public JunVrmlMFVec3fField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Convert to an array of Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 */
	public Jun3dPoint[] as3dPoints() {
		Jun3dPoint[] points = new Jun3dPoint[value.length / 3];

		for (int i = 0; i < value.length; i += 3) {
			points[i / 3] = new Jun3dPoint(value[i], value[i + 1], value[i + 2]);
		}

		return points;
	}

	/**
	 * Answer my value.
	 * 
	 * @return float[]
	 */
	public float[] value() {
		return value;
	}

	/**
	 * Set the numbers as a value.
	 * 
	 * @param numbers float[]
	 */
	public void value_(float[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new float[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].floatValue();
		}
	}
}
