package jp.co.sra.jun.vrml.field.mf;

import java.util.Vector;
import jp.co.sra.jun.vrml.field.abstracts.*;

/**
 * JunVrmlMFFloatField class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlMFFloatField.java,v 8.11 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVrmlMFFloatField extends JunVrmlMFField {
	protected float[] value;

	/**
	 * Create a new instance of JunVrmlMFFloatField and initialize it.
	 * 
	 * @param numbers float[]
	 */
	public JunVrmlMFFloatField(float[] numbers) {
		super();
		this.value_(numbers);
	}

	/**
	 * Create a JunVrmlMFFloatField and initialize it.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunVrmlMFFloatField(Object anObject) {
		this((Vector) anObject);
	}

	/**
	 * Create a JunVrmlMFFloatField and initialize it.
	 * 
	 * @param aVector java.util.Vector
	 */
	public JunVrmlMFFloatField(Vector aVector) {
		super();
		this.value_(aVector);
	}

	/**
	 * Answer my value.
	 * 
	 * @return float[]
	 */
	public float[] value() {
		return value;
	}

	/**
	 * Set my value.
	 * 
	 * @param numbers float[]
	 */
	public void value_(float[] numbers) {
		value = numbers;
	}

	/**
	 * Set my value.
	 * 
	 * @param aVector java.util.Vector
	 */
	public void value_(Vector aVector) {
		Number[] numbers = new Number[aVector.size()];
		aVector.copyInto(numbers);
		value = new float[numbers.length];

		for (int i = 0; i < numbers.length; i++) {
			value[i] = numbers[i].floatValue();
		}
	}
}
