package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;

/**
 * JunVoronoi2dPoint class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dPoint.java,v 8.10 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dPoint extends JunVoronoi2dDot {

	protected JunVoronoi2dSide side1;
	protected JunVoronoi2dSide side2;
	protected JunVoronoi2dSide side3;

	/**
	 * Create a new instance of JunVoronoi2dPoint and initialize it.
	 *
	 * @param x double
	 * @param y double
	 * @category Instance creation
	 */
	public JunVoronoi2dPoint(double x, double y) {
		super(x, y);
	}

	/**
	 * Create a new instance of JunVoronoi2dPoint and initialize it.
	 *
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunVoronoi2dPoint(Jun2dPoint aPoint) {
		this(aPoint.x(), aPoint.y());
	}

	/**
	 * Create a new instance of JunVoronoi2dPoint and initialize it.
	 *
	 * @param aPoint java.awt.Point
	 * @category Instance creation
	 */
	public JunVoronoi2dPoint(Point aPoint) {
		this(aPoint.x, aPoint.y);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		side1 = null;
		side2 = null;
		side3 = null;
	}

	/**
	 * Answer my current side1.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @category accessing
	 */
	public JunVoronoi2dSide side1() {
		return side1;
	}

	/**
	 * Set my new side1.
	 * 
	 * @param voronoi2dSide jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @category accessing 
	 */
	public void side1_(JunVoronoi2dSide voronoi2dSide) {
		side1 = voronoi2dSide;
	}

	/**
	 * Answer my current side2.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @category accessing
	 */
	public JunVoronoi2dSide side2() {
		return side2;
	}

	/**
	 * Set my new side2.
	 * 
	 * @param voronoi2dSide jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @category accessing 
	 */
	public void side2_(JunVoronoi2dSide voronoi2dSide) {
		side2 = voronoi2dSide;
	}

	/**
	 * Answer my current side3.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @category accessing
	 */
	public JunVoronoi2dSide side3() {
		return side3;
	}

	/**
	 * Set my new side3.
	 * 
	 * @param voronoi2dSide jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @category accessing 
	 */
	public void side3_(JunVoronoi2dSide voronoi2dSide) {
		side3 = voronoi2dSide;
	}

	/**
	 * Answer true if the receiver is valid.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isValid() {
		if (Double.isNaN(x)) {
			return false;
		}
		if (Double.isNaN(y)) {
			return false;
		}
		if (side1 == null || side1.isValid2() == false) {
			return false;
		}
		if (side2 == null || side2.isValid2() == false) {
			return false;
		}
		if (side3 == null || side3.isValid2() == false) {
			return false;
		}
		return true;
	}

	/**
	 * Answer true if the receiver is invalid.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isInvalid() {
		return !this.isValid();
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("point ( ");
		aWriter.write(String.valueOf(x));
		aWriter.write(" , ");
		aWriter.write(String.valueOf(y));
		aWriter.write(" )");
	}

}
