package jp.co.sra.jun.voronoi.twoD.diagram;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunVoronoi2dObject class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/06 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun627 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dObject.java,v 8.13 2008/02/20 06:33:14 nisinaka Exp $
 */
public abstract class JunVoronoi2dObject extends JunAbstractObject {
	public static final double ACCURACY = JunGeometry.ACCURACY * Math.pow(10, Math.max(0, Math.round(Math.log(1 / JunGeometry.ACCURACY) / Math.log(10) / 2 - 4)));

	/**
	 * Create a new instance of <code>JunVoronoi2dObject</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	protected JunVoronoi2dObject() {
		super();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
	}

	/**
	 * Answer my accuracy.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double accuracy() {
		return ACCURACY;
	}
}
