package jp.co.sra.jun.topology.support;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValued;

import jp.co.sra.jun.goodies.revision.JunRevisionManager;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunSolidModelingEngine class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   2007/08/014 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSolidModelingEngine.java,v 8.12 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunSolidModelingEngine extends JunAbstractObject {
	protected JunBody body;
	protected JunRevisionManager revisionManager;

	/**
	 * Create a new instance of <code>JunSolidModelingEngine</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSolidModelingEngine() {
		super();
	}

	/**
	 * Create a new instance of <code>JunSolidModelingEngine</code> and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @category Instance creation
	 */
	public JunSolidModelingEngine(JunBody aJunBody) {
		super();
		this.initializeOn_(aJunBody);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		this.initializeOn_(new JunBody());
	}

	/**
	 * Initialize the receiver with the specified a <code>JunBody</code>.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @category initialize-release
	 */
	protected void initializeOn_(final JunBody aJunBody) {
		body = (JunBody) aJunBody.copy();
		revisionManager = new JunRevisionManager(new StBlockClosure() {
			public Object value() {
				aJunBody.copyTo_(body);
				return null;
			}
		}, true);
	}

	/**
	 * Answer the receiver's body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 * @category accessing
	 */
	public JunBody body() {
		return body;
	}

	/**
	 * Answer the receiver's current revision number.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int currentRevision() {
		return this.revisionManager().currentRevision();
	}

	/**
	 * Answer the receiver's current step number.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int currentStep() {
		return this.revisionManager().currentStep();
	}

	/**
	 * Answer the receiver's last operation.
	 * 
	 * @return jp.co.sra.smalltalk.StValued
	 * @category accessing
	 */
	public StValued lastOperation() {
		return this.revisionManager().lastOperation();
	}

	/**
	 * Answer the receiver's number of revisions.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int numberOfRevisions() {
		return this.revisionManager().numberOfRevisions();
	}

	/**
	 * Answer the number of steps in the specified revision.
	 * 
	 * @param anInteger int
	 * @return int
	 * @category accessing
	 */
	public int numberOfStepsInRevision_(int anInteger) {
		return this.revisionManager().numberOfStepsInRevision_(anInteger);
	}

	/**
	 * Answer the receiver's revision manager.
	 * 
	 * @return jp.co.sra.jun.goodies.revision.JunRevisionManager
	 * @category accessing
	 */
	public JunRevisionManager revisionManager() {
		return revisionManager;
	}

	/**
	 * Set the receiver's step block.
	 * 
	 * @param aBlockClosure jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void stepBlock_(StBlockClosure aBlockClosure) {
		this.revisionManager().stepBlock_(aBlockClosure);
	}

	/**
	 * Do operation.
	 * 
	 * @param aJunAbstractOperation jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 * @return jp.co.sra.jun.topology.element.JunBody
	 * @category operation
	 */
	public JunBody operation_(JunAbstractOperator aJunAbstractOperation) {
		aJunAbstractOperation.body_(body);
		revisionManager.newOperation_(aJunAbstractOperation);
		return body;
	}

	/**
	 * Do operations.
	 * 
	 * @param aJunAbstractOperation[] jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 * @return jp.co.sra.jun.topology.element.JunBody
	 * @category operation
	 */
	public JunBody operations_(JunAbstractOperator[] anArrayOfJunAbstractOperation) {
		for (int i = 0; i < anArrayOfJunAbstractOperation.length; i++) {
			this.operation_(anArrayOfJunAbstractOperation[i]);
		}
		return body;
	}

	/**
	 * Redo the operation.
	 * 
	 * @return jp.co.sra.jun.topology.element.JunBody
	 * @category operation
	 */
	public JunBody redo() {
		this.revisionManager().redo();
		return body;
	}

	/**
	 * Undo the operation.
	 * 
	 * @return jp.co.sra.jun.topology.element.JunBody
	 * @category operation
	 */
	public JunBody undo() {
		this.revisionManager().undo();
		return body;
	}

	/**
	 * Convert the receiver as a <code>JunOpenGL3dObject</code> and show it with <code>JunOpenGLDisplayModel</code>.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category utilities
	 */
	public JunOpenGLDisplayModel show() {
		return body.show();
	}

	/**
	 * Answer the receiver's comment.
	 * 
	 * @return comment
	 * @category versioning
	 */
	public String comment() {
		return this.revisionManager().comment();
	}

	/**
	 * Set the receiver's comment.
	 * 
	 * @param aString java.lang.String
	 * @category versioning
	 */
	public void comment_(String aString) {
		this.revisionManager().comment_(aString);
	}

	/**
	 * Create the new revision.
	 * 
	 * @category versioning
	 */
	public void newRevision() {
		this.revisionManager().newRevision();
	}

	/**
	 * Remove other revisions.
	 * 
	 * @category versioning
	 */
	public void removeOtherRevisions() {
		this.revisionManager().removeOtherRevisions();
	}

	/**
	 * Answer the receiver's current revision number.
	 * 
	 * @return int
	 * @category versioning
	 */
	public int revision() {
		return this.revisionManager().currentRevision();
	}

	/**
	 * Answer the receiver's revision with the specified step.
	 * 
	 * @param anInteger1 int
	 * @param anInteger2 int
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 * @category versioning
	 */
	public JunBody revision_step_(int anInteger1, int anInteger2) {
		this.revisionManager().revision_step_(anInteger1, anInteger2);
		return body;
	}

	/**
	 * Answer the receiver's current step number.
	 * 
	 * @return int
	 * @category versioning
	 */
	public int step() {
		return this.revisionManager().currentStep();
	}

	/**
	 * Vanilla the operation.
	 * 
	 * @return jp.co.sra.jun.goodies.revision.JunRevisionManager
	 * @category versioning
	 */
	public JunRevisionManager vanilla() {
		return this.revisionManager().vanilla();
	}

	/**
	 * Set the receiver's body
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @category private
	 */
	protected void setBody_(JunBody aJunBody) {
		body = aJunBody;
	}
}
