package jp.co.sra.jun.topology.grapher;

import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.graph.JunElementalGraph;
import jp.co.sra.jun.topology.graph.JunElementalNode;

/**
 * JunGrapherTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGrapherTestExamples.java,v 8.11 2008/02/20 06:33:13 nisinaka Exp $
 */
public class JunGrapherTestExamples extends JunTestExamples {

	/**
	 * Example00: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example00_Simple() {
		JunGrapher aGrapher = ExampleSimple();
		aGrapher.open();

		return true;
	}

	/**
	 * Example01: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example01_Tree() {
		JunGrapher aGrapher = ExampleTree();
		aGrapher.open();

		return true;
	}

	/**
	 * Example02: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example02_Forest() {
		JunGrapher aGrapher = ExampleForest();
		aGrapher.open();

		return true;
	}

	/**
	 * Example04: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example04_Tokyo() {
		JunGrapher aGrapher = ExampleTokyo();
		aGrapher.open();

		return true;
	}

	/**
	 * Example05: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example05_Tokyo() {
		JunGrapher aGrapher = ExampleTokyo();
		JunElementalGraph aGraph = aGrapher.graph();
		aGraph.arrangeFormat_($("concentric"));
		aGraph.arrangeAttributeSymbol_($("cost"));
		aGraph.arrangeConcentricRadius_(350);
		aGraph.arrangeConcentricSpiral_(2);
		aGraph.arrange();
		aGrapher.open();

		return true;
	}

	/**
	 * Example06: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example06_Tokyo() {
		JunGrapher aGrapher = ExampleTokyo();
		JunElementalGraph aGraph = aGrapher.graph();
		aGraph.arrangeFormat_($("concentric"));
		aGraph.arrangeAttributeSymbol_($("distance"));
		aGraph.arrangeConcentricRadius_(400);
		aGraph.arrangeConcentricSpiral_(3);
		aGraph.arrangeConcentricGradation_(Boolean.FALSE);
		aGraph.arrange();
		aGrapher.open();

		return true;
	}

	/**
	 * Example07: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example07_Tokyo() {
		JunGrapher aGrapher = ExampleTokyo();
		JunElementalGraph aGraph = aGrapher.graph();
		aGraph.arrangeFormat_($("concentric"));
		aGraph.arrangeAttributeSymbol_($("neededTime"));
		aGraph.arrangeConcentricRadius_(350);
		aGraph.arrangeConcentricSpiral_(12);
		aGraph.arrange();
		aGrapher.open();

		return true;
	}

	/**
	 * Create an example grapher with a simple.
	 * 
	 * @return jp.co.sra.jun.topology.grapher.JunGrapher
	 * @category Examples
	 */
	protected static JunGrapher ExampleSimple() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		aGraph.arrangeFormat_($("tree"));
		aGraph.arrange();
		return JunGrapher.DefaultNewGrapher(aGraph);
	}

	/**
	 * Create an example grapher with a tree.
	 * 
	 * @return jp.co.sra.jun.topology.grapher.JunGrapher
	 * @category Examples
	 */
	protected static JunGrapher ExampleTree() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleTree();
		aGraph.arrangeFormat_($("tree"));
		aGraph.arrange();
		return JunGrapher.DefaultNewGrapher(aGraph);
	}

	/**
	 * Create an example grapher with a forest.
	 * 
	 * @return jp.co.sra.jun.topology.grapher.JunGrapher
	 * @category Examples
	 */
	protected static JunGrapher ExampleForest() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleForest();
		aGraph.arrangeFormat_($("forest"));
		aGraph.arrange();
		return JunGrapher.DefaultNewGrapher(aGraph);
	}

	/**
	 * Create an example grapher with a tree.
	 * 
	 * @return jp.co.sra.jun.topology.grapher.JunGrapher
	 * @category Examples
	 */
	protected static JunGrapher ExampleTokyo() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleTokyo();

		StBlockClosure locationDMStoNumberBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				String[] strings = JunStringUtility.Separate_dividers_((String) anObject, new char[] { '/' });
				double result = Double.parseDouble(strings[1]);
				result += Double.parseDouble(strings[2]) / 60;
				result += Double.parseDouble(strings[3]) / 3600;
				if ("W".equals(strings[0]) || "S".equals(strings[0])) {
					result *= -1;
				}
				return new Double(result);
			}
		};

		double centerLongitude = ((Number) locationDMStoNumberBlock.value_("E/139/44/40.9")).doubleValue();
		double centerLatitude = ((Number) locationDMStoNumberBlock.value_("N/35/39/16.0")).doubleValue();
		JunElementalNode[] nodes = aGraph.nodes();
		for (int i = 0; i < nodes.length; i++) {
			double longitude = ((Number) locationDMStoNumberBlock.value_(nodes[i].attributeAt_($("longitude")))).doubleValue();
			double latitude = ((Number) locationDMStoNumberBlock.value_(nodes[i].attributeAt_($("latitude")))).doubleValue();
			double scale = 7000;
			int x = (int) Math.round((longitude - centerLongitude) * scale);
			int y = (int) Math.round((latitude - centerLatitude) * scale);
			nodes[i].center_(new Point(x, -y));
		}

		aGraph.flushBoundingBox();
		StRectangle aBox = aGraph.boundingBox();
		for (int i = 0; i < nodes.length; i++) {
			Point aPoint = nodes[i].origin();
			nodes[i].origin_(new Point(aPoint.x - aBox.originX(), aPoint.y - aBox.originY()));
		}
		aGraph.flushBoundingBox();

		return JunGrapher.DefaultNewGrapher(aGraph);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunGrapherTestExamples();
	}

}
