package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.awt.Point;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunElementalNodeSettingsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalNodeSettingsTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalNodeSettingsTestExamples extends JunTestExamples {

	/**
	 * Example0: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example0() {
		JunElementalNodeSettings settings = new JunElementalNodeSettings();
		settings.compute_(new StBlockClosure() {
			public Object value_value_(Object table, Object stuff) {
				System.out.println(table.toString() + " " + stuff);
				return null;
			}
		});
		settings.open();

		return true;
	}

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunElementalNode node = new JunElementalNode();
		node.labelString_($String("Untitled"));
		node.locationPoint_(new Point(100, 200));
		node.foregroundColor_(Color.red);
		node.backgroundColor_(Color.green);
		node.borderColor_(Color.blue);
		node.borderWidth_(3);

		JunElementalNodeSettings settings = new JunElementalNodeSettings(node);
		settings.compute_(new StBlockClosure() {
			public Object value_value_(Object table, Object stuff) {
				System.out.println(table.toString() + " " + stuff);
				return null;
			}
		});
		settings.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunElementalNodeSettingsTestExamples();
	}

}
