package jp.co.sra.jun.topology.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunElementalArcTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/06 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun598 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalArcTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalArcTestExamples extends JunTestExamples {

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunElementalNode firstNode = new JunElementalNode("ASADA Mitsuhiro");
		JunElementalNode lastNode = new JunElementalNode("NISHINAKA Yoshiyuki");
		JunElementalArc arcEdge = new JunElementalArc(firstNode, lastNode);
		System.out.println(arcEdge.printString());

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunElementalNode firstNode = new JunElementalNode("ASADA Mitsuhiro");
		JunElementalNode lastNode = new JunElementalNode("NISHINAKA Yoshiyuki");
		JunElementalArc arcEdge = new JunElementalArc(firstNode, lastNode);

		int width = 450;
		int height = 300;
		StImage anImage = new StImage(width, height);
		Graphics aGraphics = null;
		try {
			firstNode.center_(new Point(width / 2 + 100, height / 2 + 50));
			lastNode.center_(new Point(width / 2 - 100, height / 2 - 50));

			aGraphics = anImage.image().getGraphics();
			firstNode.displayOn_(aGraphics);
			lastNode.displayOn_(aGraphics);
			arcEdge.displayOn_(aGraphics);

		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}
		anImage._display();

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunElementalNode firstNode = new JunElementalNode("ASADA Mitsuhiro");
		JunElementalNode lastNode = new JunElementalNode("NISHINAKA Yoshiyuki");
		JunElementalArc arcEdge = new JunElementalArc(firstNode, lastNode);
		arcEdge.lineWidth_(3);
		arcEdge.lineColor_(Color.red);
		arcEdge.firstBoxColor_(Color.green);
		arcEdge.lastBoxColor_(Color.blue);
		arcEdge.firstPointAlignment_($("topLeft"));
		arcEdge.lastPointAlignment_($("bottomRight"));

		int width = 450;
		int height = 300;
		StImage anImage = new StImage(width, height);
		Graphics aGraphics = null;
		try {
			firstNode.center_(new Point(width / 2 + 100, height / 2 + 50));
			lastNode.center_(new Point(width / 2 - 100, height / 2 - 50));

			aGraphics = anImage.image().getGraphics();
			firstNode.displayOn_(aGraphics);
			lastNode.displayOn_(aGraphics);
			arcEdge.displayOn_(aGraphics);

		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}
		anImage._display();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunElementalArcTestExamples();
	}

}
