package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.abstracts.JunGlobalOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;

/**
 * JunROTATE class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunROTATE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunROTATE extends JunGlobalOperator {
	protected Jun3dPoint point;
	protected Jun3dPoint vector;
	protected JunAngle angle;

	/**
	 * Create a new instance of JunROTATE and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * 
	 * @return jp.co.sra.jun.topology.globaloperators.JunROTATE
	 */
	public static final JunROTATE Body_point_vector_angle_(JunBody aJunBody, Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, double aNumber) {
		JunROTATE anOperator = new JunROTATE();
		anOperator.body_(aJunBody);
		anOperator.point_(aJun3dPoint1);
		anOperator.vector_(aJun3dPoint2);
		anOperator.angle_(aNumber);

		return anOperator;
	}

	/**
	 * Create a new instance of JunROTATE and initialize it.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * 
	 * @return jp.co.sra.jun.topology.globaloperators.JunROTATE
	 */
	public static final JunROTATE Body_point_vector_angle_(JunBody aJunBody, Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, JunAngle aJunAngle) {
		JunROTATE anOperator = new JunROTATE();
		anOperator.body_(aJunBody);
		anOperator.point_(aJun3dPoint1);
		anOperator.vector_(aJun3dPoint2);
		anOperator.angle_(aJunAngle);

		return anOperator;
	}

	/**
	 * Answer the angle.
	 * 
	 * @return double
	 */
	public final JunAngle angle() {
		return angle;
	}

	/**
	 * Set the angle.
	 * 
	 * @param aNumber double
	 */
	public void angle_(double aNumber) {
		angle = JunAngle.FromRad_(aNumber);
	}

	/**
	 * Set the angle.
	 * 
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 */
	public final void angle_(JunAngle anAngle) {
		angle = anAngle;
	}

	/**
	 * Execute the receiver.
	 */
	public void execute() {
		final Jun3dTransformation rotation = Jun3dTransformation.Rotate_around_(this.angle(), new Jun3dLine(this.point(), (Jun3dPoint) this.point().plus_(this.vector())));
		this.body().vertexesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunVertex vertex = (JunVertex) anObject;

				if (vertex.point() != null) {
					vertex.point_((Jun3dPoint) vertex.point().transform_(rotation));
				}

				return null;
			}
		});
		this.body().edgesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunEdge edge = (JunEdge) anObject;
				Jun3dLine curve = (Jun3dLine) edge.basicCurve();

				if (curve != null) {
					edge.setCurve_((JunCurve) curve.transform_(rotation));
				}

				return null;
			}
		});
		this.body().loopsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunLoop loop = (JunLoop) anObject;
				Jun3dPolygon surface = (Jun3dPolygon) loop.basicSurface();

				if (surface != null) {
					loop.setSurface_((JunSurface) surface.transform_(rotation));
				}

				return null;
			}
		});
	}

	/**
	 * Answer the inverse operation of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunROTATE.Body_point_vector_angle_(this.body(), this.point(), this.vector(), this.angle().negated());
	}

	/**
	 * Answer the point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final Jun3dPoint point() {
		return point;
	}

	/**
	 * Set the point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final void point_(Jun3dPoint aJun3dPoint) {
		point = aJun3dPoint;
	}

	/**
	 * Answer the vector.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final Jun3dPoint vector() {
		return vector;
	}

	/**
	 * Set the vector.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final void vector_(Jun3dPoint aJun3dPoint) {
		vector = aJun3dPoint;
	}
}
