package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunPointSCALETestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPointSCALETestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunPointSCALETestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		JunLoop loop1 = mevvl.loop();
		JunVertex v100 = mevvl.newVertex1();
		JunVertex v010 = mevvl.newVertex2();
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, v100, loop1, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex v000 = mev.newVertex();
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop1, v010, v000);
		mel.doOperation();
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 1), new Jun3dPoint(0, 1, 1));
		mevvl.doOperation();

		JunLoop loop2 = mevvl.loop();
		JunVertex v101 = mevvl.newVertex1();
		JunVertex v011 = mevvl.newVertex2();
		mev = JunMEV.Body_vertex_loop_point_(body, v101, loop2, new Jun3dPoint(0, 0, 1));
		mev.doOperation();

		JunVertex v001 = mev.newVertex();
		mel = JunMEL.Body_loop_vertex_vertex_(body, loop2, v011, v001);
		mel.doOperation();

		JunMCLKPL mcl = JunMCLKPL.Body_loop_loop_(body, loop1, loop2);
		mcl.doOperation();

		JunPointSCALE scale = JunPointSCALE.Body_point_factor_(body, new Jun3dPoint(0, 0, 0), 0.5);
		scale.doOperation();
		scale.body().show();

		JunVertex[] vertexes = body.vertexes();

		for (int i = 0; i < vertexes.length; i++) {
			JunVertex vertex = vertexes[i];
			System.out.println("-------- #vertex");
			System.out.println(vertex);
		}

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example2() {
		JunBody body;
		JunPointSCALE scale;
		Jun3dPoint p1 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint p2 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint p3 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint p4 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = p1;
		a3dPoint[1] = p2;
		a3dPoint[2] = p3;
		a3dPoint[3] = p4;
		body = JunBody.Tetrahedron_(a3dPoint);
		body.show();

		//	body = JunBody.Tetrahedron_((StArray)StArray.With_with_with_with_(StArray.class,p1,p2,p3,p4));
		scale = JunPointSCALE.Body_point_factor_(body, p1 /*Jun3dPoint.Zero()*/
		, 2.0d);
		scale.doOperation();
		scale.body().show();

		//	return scale;
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example3() {
		JunBody body;
		JunPointSCALE scale;
		Jun3dPoint p1 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint p2 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint p3 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint p4 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = p1;
		a3dPoint[1] = p2;
		a3dPoint[2] = p3;
		a3dPoint[3] = p4;
		body = JunBody.Tetrahedron_(a3dPoint);

		//	body = JunBody.Tetrahedron_((StArray)StArray.With_with_with_with_(StArray.class,p1,p2,p3,p4));
		scale = JunPointSCALE.Body_point_factor_(body, p1 /*Jun3dPoint.Zero()*/
		, 2.0d);
		body.show();
		scale.doOperation();
		body.show();
		scale.inverse().doOperation();
		body.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example4() {
		JunBody body;
		JunPointSCALE scale;
		Jun3dPoint p1 = new Jun3dPoint(10, 10, 10);
		Jun3dPoint p2 = new Jun3dPoint(11, 10, 10);
		Jun3dPoint p3 = new Jun3dPoint(10, 11, 10);
		Jun3dPoint p4 = new Jun3dPoint(10, 10, 11);
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = p1;
		a3dPoint[1] = p2;
		a3dPoint[2] = p3;
		a3dPoint[3] = p4;
		body = JunBody.Tetrahedron_(a3dPoint);

		//	body = JunBody.Tetrahedron_((StArray)StArray.With_with_with_with_(StArray.class,p1,p2,p3,p4));
		scale = JunPointSCALE.Body_point_factor_(body, p2, 2.0d);
		body.show();
		scale.doOperation();
		body.show();
		scale.inverse().doOperation();
		body.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 */
	public static void main(java.lang.String[] args) {
		new JunPointSCALETestExamples();
	}
}
