package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunNEGATETestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNEGATETestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunNEGATETestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunMEVVL mevvl;
		JunMEV mev;
		JunMEL mel;
		JunBody body;
		JunNEGATE negate;
		JunVertex v000;
		JunVertex v100;
		JunVertex v010;
		JunLoop loop;
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		loop = mevvl.newLoop();
		v100 = mevvl.newVertex1();
		v010 = mevvl.newVertex2();
		mev = JunMEV.Body_vertex_loop_point_(body, v100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		v000 = mev.newVertex();
		mel = JunMEL.Body_loop_vertex_vertex_(body, loop, v010, v000);
		mel.doOperation();
		body.show();
		negate = JunNEGATE.Body_(body);
		negate.doOperation();
		negate.body().show();

		//#?# body #vertexes
		JunVertex[] vertexes = body.vertexes();

		for (int i = 0; i < vertexes.length; i++) {
			JunVertex vertex = vertexes[i];
			System.out.println("-------- #vertex");
			System.out.println(vertex);
		}

		return true;
	}

	/**
	 * JunNEGATE example2.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		Jun3dPoint[] points = { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 0, 1)};
		JunBody body = JunBody.Tetrahedron_(points);
		JunNEGATE negate = new JunNEGATE(body);
		negate.doOperation();
		body.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunNEGATETestExamples();
	}
}
