package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.system.support.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunTVTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTVTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunTVTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body;
		JunMEVVL mevvl;
		JunMEL mel;
		JunMVE mve;
		JunTV tv;
		JunVertex vertex100;
		JunVertex vertex010;
		JunLoop loop;
		JunVertex vertex001;
		JunMEV mev;
		JunVertex vertex000;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		vertex100 = mevvl.vertex1();
		vertex010 = mevvl.vertex2();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();
		loop = mel.newLoop();
		mve = JunMVE.Body_edge_point_(body, mel.newEdge(), new Jun3dPoint(0, 0, 1));
		mve.doOperation();
		vertex001 = mve.newVertex();
		mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		vertex000 = mev.newVertex();
		(JunMEL.Body_loop_vertex_vertex_(body, loop, vertex000, vertex010)).doOperation();
		(JunMEL.Body_loop_vertex_vertex_(body, loop, vertex000, vertex001)).doOperation();
		body.show();
		tv = JunTV.Body_vertex_vector_(body, vertex100, new Jun3dPoint(2, 0, 0));
		tv.doOperation();
		body.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 */
	public static void main(String[] args) {
		new JunTVTestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean ManualExample1a() {
		JunBody body;
		JunMEVVL mevvl;
		JunMEV mev;
		JunMEL mel;
		JunTV tv;
		JunVertex vertex100;
		JunVertex vertex010;
		JunVertex vertex000;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		vertex100 = mevvl.newVertex1();
		vertex010 = mevvl.newVertex2();

		//
		mev = JunMEV.Body_vertex_loop_point_(body, vertex100, mevvl.loop(), new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		vertex000 = mev.newVertex();

		//
		mel = JunMEL.Body_loop_vertex_vertex_(body, mev.loop(), vertex010, vertex000);
		mel.doOperation();

		//
		body.show();
		tv = JunTV.Body_vertex_vector_(body, vertex000, new Jun3dPoint(1, 1, 0));
		tv.doOperation();
		body.show();

		//
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean ManualExample1b() {
		JunBody body;
		JunMEVVL mevvl;
		JunMEV mev;
		JunMEL mel;
		JunTV tv;
		JunVertex vertex100;
		JunVertex vertex010;
		JunVertex vertex000;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		vertex100 = mevvl.newVertex1();
		vertex010 = mevvl.newVertex2();

		//
		mev = JunMEV.Body_vertex_loop_point_(body, vertex100, mevvl.loop(), new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		vertex000 = mev.newVertex();

		//
		mel = JunMEL.Body_loop_vertex_vertex_(body, mev.loop(), vertex010, vertex000);
		mel.doOperation();

		//
		body.show();
		tv = JunTV.Body_vertex_vector_(body, vertex000, new Jun3dPoint(1, 1, 0));
		tv.doOperation();
		body.show();

		//
		System.out.println("-------- #vector");
		System.out.println(tv.vector());
		System.out.println("-------- #vertex");
		System.out.println(tv.vertex());

		//
		return true;
	}
}
