package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.abstracts.*;

/*
 * @(#)JunTV.java        1.0 98/9/17
 */
import jp.co.sra.jun.topology.elements.*;

/**
 * JunTV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunTV extends JunGeometricOperator {
	protected JunVertexProxy vertexProxy;
	protected Jun3dPoint vector;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aVertex jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunTV
	 */
	public static final JunTV Body_vertex_vector_(JunBody aBody, JunTopologicalElementOrProxy aVertex, Jun3dPoint aPoint) {
		JunTV anOperator = new JunTV();
		anOperator.body_(aBody);
		anOperator.vertex_(aVertex); //Or Proxy ????
		anOperator.vector_(aPoint);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunVertex vertex = this.vertex();
		vertex.point_((Jun3dPoint) ((vertex.point()).plus_(this.vector())));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunTV.Body_vertex_vector_(this.body(), vertexProxy, (Jun3dPoint) (this.vector().negated())));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		return (this.vertex() != null && super.precondition());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint vector() {
		return vector;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void vector_(Jun3dPoint aPoint) {
		vector = aPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex() {
		return (JunVertex) this.getTopologicalElement_(vertexProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex_(JunTopologicalElementOrProxy aVertexOrProxy) {
		vertexProxy = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aVertexOrProxy, vertexProxy);
	}
}
