package jp.co.sra.jun.topology.geometricoperators;

import java.awt.Point;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunTSF class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTSF.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunTSF extends JunGeometricOperator {
	protected JunLoopProxy loopProxy;
	//protected StPoint number;
	protected Point number;
	protected Jun3dPoint vector;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aSTPoint StPoint
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunTSF
	 */
	public static final JunTSF Body_loop_number_vector_(JunBody aBody, JunTopologicalElementOrProxy aLoopOrProxy, /*StPoint aSTPoint,*/
	Point aSTPoint, Jun3dPoint aPoint) {
		JunTSF anOperator = new JunTSF();
		anOperator.body_(aBody);
		anOperator.loop_(aLoopOrProxy);
		anOperator.number_(aSTPoint);
		anOperator.vector_(aPoint);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunNurbsSurface surface = (JunNurbsSurface) ((this.loop()).basicSurface());
		Jun3dPoint newPoint = (Jun3dPoint) surface.controlPointAt_(this.number()).plus_(this.vector());
		surface.controlPointAt_put_(this.number(), newPoint);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunTSF.Body_loop_number_vector_(this.body(), loopProxy, this.number(), (Jun3dPoint) this.vector().negated());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(loopProxy);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param aLoopOrProxy DOCUMENT ME!
	 */
	public void loop_(JunTopologicalElementOrProxy aLoopOrProxy) {
		loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aLoopOrProxy, loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return StPoint
	 */
	public /*StPoint*/
	Point number() {
		return number;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aPoint StPoint
	 */
	public void number_(Point aPoint) {
		this.number = aPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunLoop loop = this.loop();

		if (loop == null) {
			return false;
		}

		JunNurbsSurface surface = (JunNurbsSurface) (loop.basicSurface());

		if (surface == null) {
			return false;
		}

		if (!(surface instanceof JunNurbsSurface)) {
			return false;
		}

		if (!(surface.respondsTo_("controlPointAt_put_"))) {
			return false;
		}

		Point size = surface.controlPointSize();

		if (size.x < this.number().x) {
			return false;
		}

		if (size.y < this.number().y) {
			return false;
		}

		return super.precondition();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint vector() {
		return vector;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void vector_(Jun3dPoint aPoint) {
		vector = aPoint;
	}
}
