package jp.co.sra.jun.topology.geometricoperators;

/*
 * @(#)JunTCV.java        1.0 98/9/17
 */
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunTCV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTCV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunTCV extends JunGeometricOperator {
	protected JunEdgeProxy edgeProxy;
	protected int number;
	protected Jun3dPoint vector;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param anEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param anInteger int
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunTCV
	 */
	public static final JunTCV Body_edge_number_vector_(JunBody aBody, JunTopologicalElementOrProxy anEdgeOrProxy, int anInteger, Jun3dPoint aPoint) {
		JunTCV anOperator = new JunTCV();
		anOperator.body_(aBody);
		anOperator.edge_(anEdgeOrProxy);
		anOperator.number_(anInteger);
		anOperator.vector_(aPoint);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy anEdgeOrProxy) {
		edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(anEdgeOrProxy, edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunNurbsCurve curve = (JunNurbsCurve) ((this.edge()).basicCurve());
		Jun3dPoint newPoint = (Jun3dPoint) curve.controlPointAt_(this.number()).plus_(this.vector());
		curve.controlPointAt_put_(this.number(), newPoint);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunTCV.Body_edge_number_vector_(this.body(), edgeProxy, this.number(), (Jun3dPoint) this.vector().negated());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return int
	 */
	public int number() {
		return number;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anInteger int
	 */
	public void number_(int anInteger) {
		number = anInteger;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunEdge edge = this.edge();

		if (edge == null) {
			return false;
		}

		JunCurve curve = edge.basicCurve();

		if (curve == null) {
			return false;
		}

		if (!(curve instanceof JunNurbsCurve)) {
			return false;
		}

		if (((JunNurbsCurve) curve).controlPointSize() < this.number()) {
			return false;
		}

		return super.precondition();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint vector() {
		return vector;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void vector_(Jun3dPoint aPoint) {
		vector = aPoint;
	}
}
