package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.JunNurbsSurface;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;
import jp.co.sra.jun.topology.euleroperators.JunMEL;
import jp.co.sra.jun.topology.euleroperators.JunMEV;
import jp.co.sra.jun.topology.euleroperators.JunMEVVL;
import jp.co.sra.jun.topology.euleroperators.JunMVE;

/**
 * JunMSFTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMSFTestExamples.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMSFTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		JunLoop loop = mevvl.newLoop();

		JunVertex v100 = mevvl.newVertex1();
		JunVertex v010 = mevvl.newVertex2();
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, v100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex v000 = mev.newVertex();
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop, v010, v000);
		mel.doOperation();
		loop = mel.newLoop();
		body.show();
		JunMatrix matrix = new JunMatrix(3);
		matrix._put(0, 0, new Jun3dPoint(0, 0, 0));
		matrix._put(0, 1, new Jun3dPoint(0.5, 0, 0));
		matrix._put(0, 2, new Jun3dPoint(1, 0, 0));
		matrix._put(1, 0, new Jun3dPoint(0, 0, 0));
		matrix._put(1, 1, new Jun3dPoint(0.3, 0.3, 0.5));
		matrix._put(1, 2, new Jun3dPoint(0.5, 0.5, 1));
		matrix._put(2, 0, new Jun3dPoint(0, 0, 0));
		matrix._put(2, 1, new Jun3dPoint(0, 0.5, 0));
		matrix._put(2, 2, new Jun3dPoint(0, 1, 0));
		JunNurbsSurface surface = JunNurbsSurface.BezierControlPoints_(matrix);
		JunMSF msf = JunMSF.Body_loop_surface_(body, loop, surface);
		msf.doOperation();
		body.show();

		//#?# msf
		System.out.println("-------- #surface");
		System.out.println(msf.surface());
		System.out.println("-------- #loop");
		System.out.println(msf.loop());

		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();
		JunLoop loop = mel.newLoop();
		JunMVE mve = JunMVE.Body_edge_point_(body, mel.newEdge(), new Jun3dPoint(0, -1, 0));
		mve.doOperation();
		body.show();
		JunMatrix matrix = new JunMatrix(3);
		matrix._put(0, 0, new Jun3dPoint(0, 0, 0));
		matrix._put(0, 1, new Jun3dPoint(0.5, 0, 0));
		matrix._put(0, 2, new Jun3dPoint(1, 0, 0));
		matrix._put(1, 0, new Jun3dPoint(0.25, -0.25, 0));
		matrix._put(1, 1, new Jun3dPoint(0.375, -0.375, 1));
		matrix._put(1, 2, new Jun3dPoint(0.5, -0.5, 0));
		matrix._put(2, 0, new Jun3dPoint(0, -0.5, 0));
		matrix._put(2, 1, new Jun3dPoint(0, -0.75, 0));
		matrix._put(2, 2, new Jun3dPoint(0, -1, 0));
		JunNurbsSurface surface = JunNurbsSurface.BezierControlPoints_(matrix);
		JunMSF msf = JunMSF.Body_loop_surface_(body, loop, surface);
		msf.doOperation();
		body.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunMSFTestExamples();
	}
}
