package jp.co.sra.jun.topology.geometricoperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.JunNurbsCurve;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.euleroperators.*;

/**
 * JunMCVTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMCVTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMCVTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body;
		JunMEVVL mevvl;
		JunEdge edge;
		JunMEL mel;
		JunMVE mve;
		JunNurbsCurve curve;
		JunMCV mcv;

		//
		body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0));
		mevvl.doOperation();
		edge = mevvl.edge();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), mevvl.vertex1(), mevvl.vertex2());
		mel.doOperation();
		mve = JunMVE.Body_edge_point_(body, mel.newEdge(), new Jun3dPoint(0, -1, 0));
		mve.doOperation();
		body.asWireframedOpenGL3dObject().show();
		curve = JunNurbsCurve.BezierControlPoints_(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0.5, 0, 0.5), new Jun3dPoint(1, 0, 0)});
		mcv = JunMCV.Body_edge_curve_(body, edge, curve);
		mcv.doOperation();
		body.asWireframedOpenGL3dObject().show();
		System.out.println("-------- #curve");
		System.out.println(mcv.curve());
		System.out.println("-------- #edge");
		System.out.println(mcv.edge());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 */
	public static void main(String[] args) {
		new JunMCVTestExamples();
	}
}
