package jp.co.sra.jun.topology.geometricoperators;

/*
 * @(#)JunKCV.java        1.0 98/9/17
 */
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKCV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKCV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKCV extends JunGeometricOperator {
	/** The topology on which the receiver operates. */
	protected JunEdgeProxy edgeProxy;

	/** The geometry which corresponds to the receiver's topology. */
	protected JunCurve curve;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param anEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.geometricoperators.JunKCV
	 */
	public static final JunKCV Body_edge_(JunBody aBody, JunTopologicalElementOrProxy anEdgeOrProxy) {
		JunKCV anOperator = new JunKCV();
		anOperator.body_(aBody);
		anOperator.edge_(anEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunCurve
	 */
	public JunCurve curve() {
		return curve;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aCurve jp.co.sra.jun.geometry.abstracts.JunCurve
	 */
	public void curve_(JunCurve aCurve) {
		curve = aCurve;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param anEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy anEdgeOrProxy) {
		edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(anEdgeOrProxy, edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.curve_(this.edge().basicCurve());
		this.edge().curve_(null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMCV.Body_edge_curve_(this.body(), edgeProxy, this.curve()));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunEdge edge = this.edge();

		if (edge == null) {
			return false;
		}

		if (edge.basicCurve() == null) {
			return false;
		}

		return super.precondition();
	}
}
