package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMVE class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/08/04 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMVE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMVE extends JunEulerOperator {
	protected JunVertexProxy vertexProxy;
	protected JunEdgeProxy edgeProxy1;
	protected JunEdgeProxy edgeProxy2;
	protected Jun3dPoint point;
	protected JunVertexProxy vertexProxy1;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMVE
	 */
	public static JunMVE Body_edge_point_(JunBody aJunBody, JunTopologicalElementOrProxy aJunEdgeOrProxy, Jun3dPoint aJun3dPoint) {
		return Body_edge_point_adviseVertex_edge_newEdgeOnVertex_(aJunBody, aJunEdgeOrProxy, aJun3dPoint, null, null, null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMVE
	 */
	public static final JunMVE Body_edge_point_adviseVertex_edge_newEdgeOnVertex_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		Jun3dPoint aJun3dPoint,
		JunTopologicalElementOrProxy aJunVertexOrProxy,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2,
		JunTopologicalElementOrProxy aJunVertexOrProxy1) {
		JunMVE anOperator;
		anOperator = new JunMVE();
		anOperator.body_(aJunBody);
		anOperator.edge1_(aJunEdgeOrProxy2);
		anOperator.edge2_(aJunEdgeOrProxy);
		anOperator.point_(aJun3dPoint);
		anOperator.vertex_(aJunVertexOrProxy);
		anOperator.vertex1_(aJunVertexOrProxy1);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMVE
	 */
	public static JunMVE Body_edge_point_newEdgeOnVertex_(JunBody aJunBody, JunTopologicalElementOrProxy aJunEdgeOrProxy, Jun3dPoint aJun3dPoint, JunTopologicalElementOrProxy aJunVertexOrProxy) {
		return Body_edge_point_adviseVertex_edge_newEdgeOnVertex_(aJunBody, aJunEdgeOrProxy, aJun3dPoint, null, null, aJunVertexOrProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge1() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge1_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy1 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunEdge fromEdge1;
		this.vertex_(JunVertex.Point_(this.point()));
		this.vertex().edge_(this.edge2());
		this.edge1_((JunEdge) (this.edge2().copy()));

		if (this.vertex1() != this.edge2().endVertex()) {
			fromEdge1 = this.edge2().prevEdgeWithVertex_(this.edge2().startVertex());
			fromEdge1.setNextEdge_withVertex_(this.edge1(), this.edge2().startVertex());

			if (this.edge2().startVertex().edge() == this.edge2()) {
				this.edge2().startVertex().edge_(this.edge1());
			}

			this.edge1().endVertex_(this.vertex());
			this.edge2().startVertex_(this.vertex());
			this.edge1().endLeftEdge_(this.edge2());
			this.edge2().startRightEdge_(this.edge1());

			if (this.edge1().startRightEdge() == this.edge2()) {
				this.edge1().startRightEdge_(this.edge1());
			}
		} else {
			fromEdge1 = this.edge2().prevEdgeWithVertex_(this.edge2().endVertex());
			fromEdge1.setNextEdge_withVertex_(this.edge1(), this.edge2().endVertex());

			if (this.edge2().endVertex().edge() == this.edge2()) {
				this.edge2().endVertex().edge_(this.edge1());
			}

			this.edge1().startVertex_(this.vertex());
			this.edge2().endVertex_(this.vertex());
			this.edge1().startRightEdge_(this.edge2());
			this.edge2().endLeftEdge_(this.edge1());

			if (this.edge1().endLeftEdge() == this.edge2()) {
				this.edge1().endLeftEdge_(this.edge1());
			}
		}

		this.body().addVertex_(this.vertex());
		this.body().addEdge_(this.edge1());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKVE.Body_vertex_adviseEdge_edge_(this.body(), this.vertexProxy, this.edgeProxy1, this.edgeProxy2));
	}

	/**
	 * Answer my new edge.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge newEdge() {
		return this.edge1();
	}

	/**
	 * Answer my new vertex.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex newVertex() {
		return this.vertex();
	}

	/**
	 * Answer my original edge.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge originalEdge() {
		return this.edge2();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point() {
		return this.point;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public void point_(Jun3dPoint aPoint) {
		this.point = aPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		if (this.edge2() == null) {
			return false;
		} else {
			return super.precondition();
		}
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}
}
