package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMEKL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMEKL.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMEKL extends JunEulerOperator {
	protected JunEdgeProxy edgeProxy;
	protected JunLoopProxy loopProxy1;
	protected JunLoopProxy loopProxy2;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunEdgeProxy edgeProxy2;
	protected JunEdgeProxy edgeProxy3;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunLoopOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEKL
	 */
	public static JunMEKL Body_killLoop_aliveLoop_vertex_vertex_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunLoopOrProxy1,
		JunTopologicalElementOrProxy aJunLoopOrProxy2,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2) {
		return Body_loop_loop_vertex_vertex_adviseEdge_edge_edge_(aJunBody, aJunLoopOrProxy1, aJunLoopOrProxy2, aJunVertexOrProxy1, aJunVertexOrProxy2, null, null, null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunLoopOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEKL
	 */
	public static JunMEKL Body_loop_loop_vertex_vertex_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunLoopOrProxy1,
		JunTopologicalElementOrProxy aJunLoopOrProxy2,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2) {
		return Body_loop_loop_vertex_vertex_adviseEdge_edge_edge_(aJunBody, aJunLoopOrProxy1, aJunLoopOrProxy2, aJunVertexOrProxy1, aJunVertexOrProxy2, null, null, null);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunLoopOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunLoopOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy3
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunMEKL
	 */
	public static final JunMEKL Body_loop_loop_vertex_vertex_adviseEdge_edge_edge_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunLoopOrProxy1,
		JunTopologicalElementOrProxy aJunLoopOrProxy2,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy3) {
		JunMEKL anOperator;
		anOperator = new JunMEKL();
		anOperator.body_(aJunBody);
		anOperator.loop1_(aJunLoopOrProxy1);
		anOperator.loop2_(aJunLoopOrProxy2);
		anOperator.vertex1_(aJunVertexOrProxy1);
		anOperator.vertex2_(aJunVertexOrProxy2);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);
		anOperator.edge3_(aJunEdgeOrProxy3);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop aliveLoop() {
		return this.loop2();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.Junedge
	 */
	public JunEdge edge3() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge3_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy3 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy3);
	}

	/**
	 * Execute the operation.
	 */
	public void execute() {
		this.edge_(JunEdge.StartVertex_endVertex_(this.vertex1(), this.vertex2()));
		this.edge().leftLoop_(this.loop2());
		this.edge().rightLoop_(this.loop2());

		JunEdge[] edges = this.loop1().edges();
		JunEdge fromEdge1;

		if (this.edge2() == null) {
			fromEdge1 = this.loop1().edgeToVertex_(this.vertex1());
			this.edge2_(fromEdge1);
		} else {
			fromEdge1 = this.edge2();
		}

		JunEdge toEdge1 = fromEdge1.nextEdgeWithVertex_(this.vertex1());
		JunEdge fromEdge2;

		if (this.edge3() == null) {
			fromEdge2 = this.loop2().edgeToVertex_(this.vertex2());
			this.edge3_(fromEdge2);
		} else {
			fromEdge2 = this.edge3();
		}

		JunEdge toEdge2 = fromEdge2.nextEdgeWithVertex_(this.vertex2());
		fromEdge1.setNextEdge_withVertex_(this.edge(), this.vertex1());
		this.edge().setNextEdge_withVertex_(toEdge1, this.vertex1());
		fromEdge2.setNextEdge_withVertex_(this.edge(), this.vertex2());
		this.edge().setNextEdge_withVertex_(toEdge2, this.vertex2());

		for (int i = 0; i < edges.length; i++) {
			edges[i].setLoop_insteadOf_(this.loop2(), this.loop1());
		}

		this.loop1().forget();
		this.body().removeLoop_(this.loop1());
		this.body().addEdge_(this.edge());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunKEML.Body_edge_adviseLoop_vertex_vertex_edge_edge_(this.body(), edgeProxy, loopProxy1, vertexProxy1, vertexProxy2, edgeProxy2, edgeProxy3));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop killedLoop() {
		return this.loop1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop1() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop1_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy1 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop2() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop2_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy2 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge newEdge() {
		return this.edge();
	}

	/**
	 * Precondition to check before executing the operation.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		if (super.precondition() == false) {
			return false;
		}

		JunLoop loop1 = this.loop1();

		if (loop1 == null) {
			return false;
		}

		JunLoop loop2 = this.loop2();

		if (loop2 == null) {
			return false;
		}

		JunVertex vertex1 = this.vertex1();

		if (vertex1 == null) {
			return false;
		}

		JunVertex vertex2 = this.vertex2();

		if (vertex2 == null) {
			return false;
		}

		if (this.edge() != null) {
			return false;
		}

		if (loop1.includesVertex_(vertex1) == false) {
			return false;
		}

		if (loop2.includesVertex_(vertex2) == false) {
			return false;
		}

		if (loop1 == loop2) {
			return false;
		}

		return true;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
