package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMCLKPLTestExamples class
 * 
 *  @author    bnr
 *  @created   1999/08/19 (by bnr)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMCLKPLTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMCLKPLTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	// @see: JunMCLKPLTestExamples#Example1
	//
	// to compile:
	//  c:>cd \...\sra\jun\topology\globaloperators
	//  c:>javac JunMCLKPLTestExamples.java
	//
	// to run:
	//  c:>java jp.co.sra.jun.topology.euleroperators.JunMCLKPLTestExamples
	//
	//  use Examples menu to choose:
	//    Example1  manipulate parent and child loops

	/**
	 * The example on JunMCLKPL.htm
	 * 
	 * @return boolean.
	 */
	public static boolean Example1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		JunLoop loop1 = mevvl.loop();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex010 = mevvl.newVertex2();

		//
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop1, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex vertex000 = mev.newVertex();

		//
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop1, vertex010, vertex000);
		mel.doOperation();

		//
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 1), new Jun3dPoint(0, 1, 1));
		mevvl.doOperation();

		JunLoop loop2 = mevvl.loop();
		JunVertex vertex101 = mevvl.newVertex1();
		JunVertex vertex011 = mevvl.newVertex2();

		//
		mev = JunMEV.Body_vertex_loop_point_(body, vertex101, loop2, new Jun3dPoint(0, 0, 1));
		mev.doOperation();

		JunVertex vertex001 = mev.newVertex();

		//
		mel = JunMEL.Body_loop_vertex_vertex_(body, loop2, vertex011, vertex001);
		mel.doOperation();

		//
		JunMCLKPL mclkpl = JunMCLKPL.Body_loop_loop_(body, loop1, loop2);
		mclkpl.doOperation();

		//
		body.show();

		//  		JunMCLKPL MCLKPL = JunMCLKPL.Body_loop_(body, loop2);
		//  		MCLKPL.doOperation();
		//  		body.show();
		//
		System.out.println("-------- #loop1");
		System.out.println(mclkpl.loop1());
		System.out.println("-------- #loop2");
		System.out.println(mclkpl.loop2());

		//
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunMCLKPLTestExamples();
	}
}
