package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKEVVL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKEVVL.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKEVVL extends JunEulerOperator {
	protected Jun3dPoint point1;
	protected Jun3dPoint point2;
	protected JunEdgeProxy edgeProxy;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunLoopProxy loopProxy;

	/**
	 * Create a new instance of JunKEVVL and initialize it with a JunBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunKEVVL(JunBody aBody) {
		super(aBody);
	}

	/**
	 * Create a new instance of JunKEVVL and initialize it.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEVVL
	 */
	public static final JunKEVVL Body_edge_(JunBody aBody, JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		JunKEVVL anOperator = new JunKEVVL(aBody);
		anOperator.edge_(aJunEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.vertex1_(this.edge().startVertex());
		this.vertex2_(this.edge().endVertex());
		this.loop_(this.edge().leftLoop());
		point1 = this.vertex1().point();
		point2 = this.vertex2().point();
		this.edge().forget();
		this.vertex1().forget();
		this.vertex2().forget();
		this.loop().forget();
		this.body().removeLoop_(this.loop());
		this.body().removeEdge_(this.edge());
		this.body().removeVertex_(this.vertex1());
		this.body().removeVertex_(this.vertex2());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMEVVL.Body_point_point_adviseEdge_vertex_vertex_loop_(this.body(), this.point1(), this.point2(), this.edgeProxy, this.vertexProxy1, this.vertexProxy2, this.loopProxy));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point1() {
		return this.point1;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point2() {
		return this.point2;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunEdge edge;

		if (super.precondition() == false) {
			return false;
		}

		edge = this.edge();

		if (edge == null) {
			return false;
		}

		if (edge != edge.startRightEdge()) {
			return false;
		}

		if (edge != edge.endLeftEdge()) {
			return false;
		}

		if (edge.leftLoop() != edge.rightLoop()) {
			return false;
		}

		return true;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
