package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKEV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKEV.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKEV extends JunEulerOperator {
	protected Jun3dPoint point;
	protected JunEdgeProxy edgeProxy;
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunLoopProxy loopProxy;
	protected JunEdgeProxy edgeProxy2;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEV
	 */
	public static final JunKEV Body_edge_vertex_(JunBody aBody, JunTopologicalElementOrProxy aJunEdgeOrProxy, JunTopologicalElementOrProxy aJunVertexOrProxy) {
		JunKEV anOperator;
		anOperator = new JunKEV();
		anOperator.body_(aBody);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.vertex1_(aJunVertexOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKEV
	 */
	public static final JunKEV Body_edge_vertex_adviseEdge_(JunBody aJunBody, JunTopologicalElementOrProxy aJunEdgeOrProxy, JunTopologicalElementOrProxy aJunVertexOrProxy, JunTopologicalElementOrProxy aJunEdgeOrProxy2) {
		JunKEV anOperator;
		anOperator = new JunKEV();
		anOperator.body_(aJunBody);
		anOperator.edge_(aJunEdgeOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy2);
		anOperator.vertex1_(aJunVertexOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunEdge fromEdge;
		JunEdge toEdge;
		point = this.vertex1().point();
		this.vertex2_(this.edge().oppositeVertexOfVertex_(this.vertex1()));
		this.loop_(this.edge().leftLoop());

		if (this.edge2() == null) {
			fromEdge = this.edge().prevEdgeWithVertex_(this.vertex2());
			this.edge2_(fromEdge);
		} else {
			fromEdge = this.edge2();
		}

		toEdge = this.edge().nextEdgeWithVertex_(this.vertex2());
		fromEdge.setNextEdge_withVertex_(toEdge, this.vertex2());

		if (this.vertex2().edge() == this.edge()) {
			this.vertex2().edge_(toEdge);
		}

		if (this.edge().leftLoop().edge() == this.edge()) {
			this.edge().leftLoop().edge_(toEdge);
		}

		if (this.edge().rightLoop().edge() == this.edge()) {
			this.edge().rightLoop().edge_(toEdge);
		}

		this.edge().forget();
		this.vertex1().forget();
		this.body().removeEdge_(this.edge());
		this.body().removeVertex_(this.vertex1());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMEV.Body_vertex_loop_point_adviseEdge_vertex_edge_(this.body(), this.vertexProxy2, this.loopProxy, this.point(), this.edgeProxy, this.vertexProxy1, this.edgeProxy2));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint point() {
		return point;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		return (super.precondition() && ((this.edge() != null) && (this.edge().leftLoop() == this.edge().rightLoop())));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
