package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.system.support.*;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKELTestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/07/29 (by BNR)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKELTestExamples.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKELTestExamples extends JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean example1() {
		JunMEVVL mevvl;
		JunMEL mel;
		JunMEV mev;
		JunKEL kel;
		JunLoop loop;
		JunVertex vertex100;
		JunVertex vertex010;
		JunVertex vertex000;
		JunBody body = new JunBody();
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		System.out.println("-------- mevvl.doOperation();");
		mevvl.doOperation();
		loop = mevvl.newLoop();
		vertex100 = mevvl.vertex1();
		vertex010 = mevvl.vertex2();
		System.out.println("-------- JunMEV");
		mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		vertex000 = mev.newVertex();
		System.out.println("-------- JunMEL");
		mel = JunMEL.Body_loop_vertex_vertex_(body, mevvl.loop(), vertex010, vertex000);
		mel.doOperation();
		System.out.println("-------- JunKEL");
		kel = JunKEL.Body_edge_(body, mel.newEdge());
		kel.doOperation();

		//not in Java: (#killedEdge )
		//in Java: (#killedLoop #aliveLoop 
		//    #vertex1 #vertex2 #edge2 #edge3)
		System.out.println("-------- #killedLoop");
		System.out.println(kel.killedLoop());
		System.out.println("\n-------- #aliveLoop");
		System.out.println(kel.aliveLoop());
		System.out.println("-------- #vertex1");
		System.out.println(kel.vertex1());
		System.out.println("\n-------- #vertex2");
		System.out.println(kel.vertex2());
		System.out.println("-------- #edge2");
		System.out.println(kel.edge2());
		System.out.println("\n-------- #edge3");
		System.out.println(kel.edge3());

		//System.out.println("\n-------- body.show()");
		//body.show().wireframePresentation();
		//return mel;
		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunKELTestExamples();
	}
}
