package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;

/*
 * @ (#) JunKDEV.java 1.0 98/9/26
 */
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.smalltalk.*;

/**
 * JunKDEV class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKDEV.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKDEV extends JunEulerOperator {
	protected JunVertexProxy vertexProxy1;
	protected JunVertexProxy vertexProxy2;
	protected JunEdgeProxy edgeProxy1;
	protected JunEdgeProxy edgeProxy2;
	protected JunEdgeProxy edgeProxy3;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKDEV
	 */
	public static final JunKDEV Body_edge_(JunBody aJunBody, JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		JunKDEV anOperator;
		anOperator = new JunKDEV();
		anOperator.body_(aJunBody);
		anOperator.edge1_(aJunEdgeOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy1
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunEdgeOrProxy2
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKDEV
	 */
	public static final JunKDEV Body_edge_adviseVertex_vertex_edge_edge_(
		JunBody aJunBody,
		JunTopologicalElementOrProxy aJunEdgeOrProxy,
		JunTopologicalElementOrProxy aJunVertexOrProxy1,
		JunTopologicalElementOrProxy aJunVertexOrProxy2,
		JunTopologicalElementOrProxy aJunEdgeOrProxy1,
		JunTopologicalElementOrProxy aJunEdgeOrProxy2) {
		JunKDEV anOperator;
		anOperator = new JunKDEV();
		anOperator.body_(aJunBody);
		anOperator.edge1_(aJunEdgeOrProxy);
		anOperator.edge2_(aJunEdgeOrProxy1);
		anOperator.edge3_(aJunEdgeOrProxy2);
		anOperator.vertex1_(aJunVertexOrProxy1);
		anOperator.vertex2_(aJunVertexOrProxy2);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKDEV
	 */
	public static final JunKDEV Body_edge_killVertex_(JunBody aJunBody, JunTopologicalElementOrProxy aJunEdgeOrProxy, JunTopologicalElementOrProxy aJunVertexOrProxy) {
		JunKDEV anOperator;
		anOperator = new JunKDEV();
		anOperator.body_(aJunBody);
		anOperator.edge1_(aJunEdgeOrProxy);
		anOperator.vertex1_(aJunVertexOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge1() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge1_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy1 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge2() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge2_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy2 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge edge3() {
		return (JunEdge) this.getTopologicalElement_(this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunEdgeOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void edge3_(JunTopologicalElementOrProxy aJunEdgeOrProxy) {
		this.edgeProxy3 = (JunEdgeProxy) this.getTopologicalElementProxy_advise_(aJunEdgeOrProxy, this.edgeProxy3);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		JunEdge fromEdge1;
		JunEdge toEdge1;
		JunEdge fromEdge2;
		JunEdge toEdge2;
		this.vertex1_(this.edge1().startVertex());
		this.vertex2_(this.edge1().endVertex());

		JunEdge[] edges = this.vertex1().edges();
		fromEdge1 = this.edge1().prevEdgeWithVertex_(this.vertex1());
		toEdge1 = this.edge1().nextEdgeWithVertex_(this.vertex1());
		fromEdge2 = this.edge1().prevEdgeWithVertex_(this.vertex2());
		toEdge2 = this.edge1().nextEdgeWithVertex_(this.vertex2());
		fromEdge1.setNextEdge_withVertex_(toEdge2, this.vertex1());
		fromEdge2.setNextEdge_withVertex_(toEdge1, this.vertex2());

		StBlockClosure correctLoopBlock = new StBlockClosure() {
				public Object value_value_(final Object loop, final Object edge) //throws Exception
	{
				if (((JunLoop) loop).edge() == JunKDEV.this.edge1()) {
					((JunLoop) loop).edge_((JunEdge) edge);

					return null;
				} else {
					return null;
				}
			}
		};

		correctLoopBlock.value_value_(this.edge1().loopToVertex_(this.vertex1()), toEdge1);
		correctLoopBlock.value_value_(this.edge1().loopToVertex_(this.vertex2()), toEdge2);

		for (int i = 0; i < edges.length; i++) {
			JunEdge edge = edges[i];
			edge.setVertex_insteadOf_(this.vertex2(), this.vertex1());
		}

		this.edge2_(toEdge1);
		this.edge3_(toEdge2);

		if (this.vertex2().edge() == this.edge1()) {
			this.vertex2().edge_(fromEdge1);
		}

		this.edge1().forget();
		this.vertex1().forget();
		this.body().removeEdge_(this.edge1());
		this.body().removeVertex_(this.vertex1());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMDEV.Body_vertex_edge_edge_adviseEdge_vertex_(this.body(), this.vertexProxy2, this.edgeProxy2, this.edgeProxy3, this.edgeProxy1, this.vertexProxy1));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunEdge
	 */
	public JunEdge killedEdge() {
		return this.edge1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex killedVertex() {
		return this.vertex1();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean postcondition() {
		return (super.postcondition() && this.body().isConsistentWithElements());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		return (super.precondition() && (this.edge1() != null));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex1() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex1_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy1 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunVertex
	 */
	public JunVertex vertex2() {
		return (JunVertex) this.getTopologicalElement_(this.vertexProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunVertexOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void vertex2_(JunTopologicalElementOrProxy aJunVertexOrProxy) {
		this.vertexProxy2 = (JunVertexProxy) this.getTopologicalElementProxy_advise_(aJunVertexOrProxy, this.vertexProxy2);
	}
}
