package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKCLMPLTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/04/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKCLMPLTestExamples.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKCLMPLTestExamples extends JunTestExamples {

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunKCLMPLTestExamples();
	}

	/**
	 * The example on JunKCLMPL.htm
	 * 
	 * @return boolean.
	 */
	public static boolean ManualExample1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		JunLoop loop1 = mevvl.loop();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex010 = mevvl.newVertex2();

		//
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop1, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunVertex vertex000 = mev.newVertex();

		//
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop1, vertex010, vertex000);
		mel.doOperation();

		//
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 1), new Jun3dPoint(0, 1, 1));
		mevvl.doOperation();

		JunLoop loop2 = mevvl.loop();
		JunVertex vertex101 = mevvl.newVertex1();
		JunVertex vertex011 = mevvl.newVertex2();

		//
		mev = JunMEV.Body_vertex_loop_point_(body, vertex101, loop2, new Jun3dPoint(0, 0, 1));
		mev.doOperation();

		JunVertex vertex001 = mev.newVertex();

		//
		mel = JunMEL.Body_loop_vertex_vertex_(body, loop2, vertex011, vertex001);
		mel.doOperation();

		//
		JunMCLKPL mclkpl = JunMCLKPL.Body_loop_loop_(body, loop1, loop2);
		mclkpl.doOperation();

		//
		body.show();

		JunKCLMPL kclmpl = JunKCLMPL.Body_loop_(body, loop2);
		kclmpl.doOperation();
		body.show();

		//
		System.out.println("-------- #loop1");
		System.out.println(kclmpl.loop1());
		System.out.println("-------- #changedLoop");
		System.out.println(kclmpl.changedLoop());

		//
		return true;
	}
}
