package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.topology.abstracts.*;

/*
 * @ (#) JunKCLMPL.java 1.0 98/9/26
 */
import jp.co.sra.jun.topology.elements.*;

/**
 * JunKCLMPL class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKCLMPL.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunKCLMPL extends JunEulerOperator {
	protected JunLoopProxy loopProxy1;
	protected JunLoopProxy loopProxy2;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKCLMPL
	 */
	public static final JunKCLMPL Body_loop_(JunBody aJunBody, JunTopologicalElementOrProxy aJunLoopOrProxy) {
		JunKCLMPL anOperator;
		anOperator = new JunKCLMPL();
		anOperator.body_(aJunBody);
		anOperator.loop2_(aJunLoopOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * @param adviseLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 * 
	 * @return jp.co.sra.jun.topology.euleroperators.JunKCLMPL
	 */
	public static final JunKCLMPL Body_loop_adviseLoop_(JunBody aJunBody, JunTopologicalElementOrProxy aLoopOrProxy, JunTopologicalElementOrProxy adviseLoopOrProxy) {
		JunKCLMPL anOperator;
		anOperator = new JunKCLMPL();
		anOperator.body_(aJunBody);
		anOperator.loop1_(adviseLoopOrProxy);
		anOperator.loop2_(aLoopOrProxy);

		return anOperator;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop changedLoop() {
		return this.loop2();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 */
	public void execute() {
		this.loop1_(this.loop2().parentLoop());
		this.loop1().removeChildLoop_(this.loop2());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return (JunAbstractOperator) (JunMCLKPL.Body_loop_loop_(this.body(), this.loopProxy1, this.loopProxy2));
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop1() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop1_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy1 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy1);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunLoop
	 */
	public JunLoop loop2() {
		return (JunLoop) this.getTopologicalElement_(this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunLoopOrProxy
	 *        jp.co.sra.jun.topology.abstracts.JunTopologicalElementOrProxy
	 */
	public void loop2_(JunTopologicalElementOrProxy aJunLoopOrProxy) {
		this.loopProxy2 = (JunLoopProxy) this.getTopologicalElementProxy_advise_(aJunLoopOrProxy, this.loopProxy2);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return boolean
	 */
	public boolean precondition() {
		JunLoop loop2;
		loop2 = this.loop2();

		if (loop2 == null) {
			return false;
		}

		return (super.precondition() && loop2.isChildLoop());
	}
}
