package jp.co.sra.jun.topology.abstracts;

import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;

/**
 * JunTopologicalElement class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   1999/08/05 (by nisinaka)
 *  @updated   2006/10/20 (by m-asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTopologicalElement.java,v 8.12 2008/02/20 06:33:01 nisinaka Exp $
 */
public abstract class JunTopologicalElement extends JunTopology implements JunTopologicalElementOrProxy {
	/**
	 * Create a new instance of <code>JunTopologicalElement</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunTopologicalElement() {
		super();
		PermitInstanceCreation();
	}

	/**
	 * Answer the default class for LispCons.
	 * 
	 * @return java.lang.Class
	 * @category Lisp support
	 */
	public static Class DefaultLispConsClass() {
		return JunLispCons.class;
	}

	/**
	 * Answer the default class for LispNil.
	 * 
	 * @return java.lang.Class
	 * @category Lisp support
	 */
	public static Class DefaultLispNilClass() {
		return JunLispNil.class;
	}

	/**
	 * Answer a cell of the LispCons.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category Lisp support
	 */
	public static JunLispCons LispCons() {
		return JunLispCons.Cell();
	}

	/**
	 * Answer a cell of the LispNil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispNil
	 * @category Lisp support
	 */
	public static JunLispNil LispNil() {
		return JunLispNil.NullList();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @category Testing
	 */
	public static void PermitInstanceCreation() {
		/*    
		 "| context |
		 context := thisContext.ext or: [context receiver isKindOf: JunTopologicalElement class]]]
		 whileTrue: [context := context sender].
		 [context notNil and: [context isBlockCont
		 (context isNil or: [context receiver isKindOf: JunEulerOperator])
		 ifFalse: [self eulerOperatorViolationSignal raise]"! !
		 */
	}

	/**
	 * Convert the receiver as a <code>JunOpenGL3dObject</code>.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public abstract JunOpenGL3dObject asJunOpenGL3dObject();

	/**
	 * Convert the receiver as a wire-framed <code>JunOpenGL3dObject</code>.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public abstract JunOpenGL3dObject asWireframedOpenGL3dObject();

	/**
	 * Answer the StSymbol which represents the receiver's kind.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category lisp support
	 */
	public StSymbol kindName() {
		return this._className();
	}

	/**
	 * Answer a lisp cons.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public JunLispCons lispCons() {
		return LispCons();
	}

	/**
	 * Answer a lisp nil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispNil
	 * @category lisp support
	 */
	public JunLispNil lispNil() {
		return LispNil();
	}

	/**
	 * Convert the receiver as a lisp list.
	 * 
	 * @param loopArray jp.co.sra.jun.topology.elements.JunLoop[]
	 * @param edgeArray jp.co.sra.jun.topology.elements.JunEdge[]
	 * @param vertexArray jp.co.sra.jun.topology.elements.JunVertex[]
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public abstract JunLispList toLispListForLoops_edges_vertexes_(JunLoop[] loopArray, JunEdge[] edgeArray, JunVertex[] vertexArray);

	/**
	 * Convert the receiver as a JunOpenGL3dObject and show it with <code>JunOpenGLDisplayModel</code>.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category utilities
	 */
	public JunOpenGLDisplayModel show() {
		JunOpenGL3dObject displayObject = this.asJunOpenGL3dObject();
		return JunOpenGLDisplayModel.Show_(displayObject);
	}
}
