package jp.co.sra.jun.topology.abstracts;

import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunGlobalOperator class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGlobalOperator.java,v 8.10 2008/02/20 06:33:01 nisinaka Exp $
 */
public abstract class JunGlobalOperator extends JunAbstractOperator {

	/**
	 * Default constructor.
	 */
	public JunGlobalOperator() {
		super();
	}

	/**
	 * Create a new instance of JunGlobalOperator and initialize it with a
	 * body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunGlobalOperator(JunBody aBody) {
		super(aBody);
	}

	/**
	 * Answer true if the receiver is a kind of Global Operator.
	 * 
	 * @return boolean
	 */
	public boolean isGlobalOperator() {
		return true;
	}

	/**
	 * Answer true if the receiver can be inverted.
	 * 
	 * @return boolean
	 */
	public boolean isInversable() {
		return true;
	}
}
