package jp.co.sra.jun.threeDImage.support;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.solid.abstracts.JunSolidModel;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.threeDImage.basic.Jun3dImage;

/**
 * Jun3dGraphicsContext class
 * 
 *  @author    kondo
 *  @created   1999/09/06 (by kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dGraphicsContext.java,v 8.12 2008/02/20 06:33:00 nisinaka Exp $
 */
public class Jun3dGraphicsContext extends JunAbstractObject {

	public static final double ACCURACY = JunGeometry.ACCURACY;

	private Jun3dImage medium;
	private Color paint;
	private Jun3dBoundingBox clippingBounds;
	private Jun3dPoint offset;
	private Jun3dPoint scale;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dImage
	 * 
	 * @return Jun3dGraphicsContext
	 */
	public static Jun3dGraphicsContext On_(Jun3dImage aJun3dImage) {
		Jun3dGraphicsContext context = new Jun3dGraphicsContext();
		context.setMedium_(aJun3dImage);

		return context;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return double
	 */
	public double accuracy() {
		return ACCURACY;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dBoundingBox
	 */
	public Jun3dBoundingBox clippingBounds() {
		return this.clippingBounds;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dBoundingBox
	 */
	public void clippingBounds_(Jun3dBoundingBox aJun3dBoundingBox) {
		this.clippingBounds = aJun3dBoundingBox;
	}

	/**
	 * Answer the default clipping bounds.
	 * 
	 * @return Jun3dBoundingBox
	 */
	public Jun3dBoundingBox defaultClippingBounds() {
		return Jun3dBoundingBox.Origin_extent_(Jun3dPoint.Zero(), this.medium().extent());
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dPoint
	 */
	public Jun3dPoint defaultOffset() {
		return Jun3dPoint.Zero();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Color
	 */
	public Color defaultPaint() {
		return this.medium().background();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dPoint
	 */
	public Jun3dPoint defaultScale() {
		return Jun3dPoint.Unity();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJunSolid
	 * @param aJun3dPoint DOCUMENT ME!
	 */
	public void displaySolid_at_(JunSolidModel aJunSolid, Jun3dPoint aJun3dPoint) {
		final Jun3dGraphicsContext this_ = this;
		final JunSolidModel aJunSolid_ = aJunSolid;
		final Color paint_ = this.paint();
		final double xOffset = this.offset.x() + aJun3dPoint.x();
		final double yOffset = this.offset.y() + aJun3dPoint.y();
		final double zOffset = this.offset.z() + aJun3dPoint.z();
		final double xScale = this.scale().x();
		final double yScale = this.scale().y();
		final double zScale = this.scale().z();
		final Jun3dBoundingBox bounds = (Jun3dBoundingBox) this.clippingBounds().intersect_(Jun3dBoundingBox.Origin_extent_(Jun3dPoint.Zero(), this.medium().extent()));
		final StBlockClosure xIterationBlock;

		if (Math.abs(xScale) > this.accuracy()) {
			xIterationBlock = new StBlockClosure() {
				public Object value_(Object argument) {
					StBlockClosure block = (StBlockClosure) argument;

					for (int mediumX = (int) ((Jun3dPoint) bounds.origin()).x(); mediumX < (int) (((Jun3dPoint) bounds.corner()).x() - 1); mediumX++) {
						block.value_value_(new Integer(mediumX), new Double((mediumX - xOffset) / xScale));
					}

					return null;
				}
			};

		} else {
			xIterationBlock = new StBlockClosure() {
				public Object value_(Object argument) {
					StBlockClosure block = (StBlockClosure) argument;
					block.value_value_(bounds.center(), new Double(((Jun3dPoint) bounds.center()).x() - xOffset));

					return null;
				}
			};

		}

		final StBlockClosure yIterationBlock;

		if (Math.abs(yScale) > this.accuracy()) {
			yIterationBlock = new StBlockClosure() {
				public Object value_(Object argument) {
					StBlockClosure block = (StBlockClosure) argument;

					for (int mediumY = (int) ((Jun3dPoint) bounds.origin()).y(); mediumY < (int) (((Jun3dPoint) bounds.corner()).y() - 1); mediumY++) {
						block.value_value_(new Integer(mediumY), new Double((mediumY - yOffset) / yScale));
					}

					return null;
				}
			};

		} else {
			yIterationBlock = new StBlockClosure() {
				public Object value_(Object argument) {
					StBlockClosure block = (StBlockClosure) argument;
					block.value_value_(bounds.center(), new Double(((Jun3dPoint) bounds.center()).y() - yOffset));

					return null;
				}
			};

		}

		StBlockClosure zIterationBlock;

		if (Math.abs(zScale) > this.accuracy()) {
			zIterationBlock = new StBlockClosure() {
				public Object value_(Object argument) {
					StBlockClosure block = (StBlockClosure) argument;

					for (int mediumZ = (int) ((Jun3dPoint) bounds.origin()).z(); mediumZ < (int) (((Jun3dPoint) bounds.corner()).z() - 1); mediumZ++) {
						block.value_value_(new Integer(mediumZ), new Double((mediumZ - zOffset) / zScale));
					}

					return null;
				}
			};

		} else {
			zIterationBlock = new StBlockClosure() {
				public Object value_(Object argument) {
					StBlockClosure block = (StBlockClosure) argument;
					block.value_value_(bounds.center(), new Double(((Jun3dPoint) bounds.center()).z() - zOffset));

					return null;
				}
			};

		}

		zIterationBlock.value_(new StBlockClosure() {
			public Object value_value_(Object argument1, Object argument2) {
				final int mediumZ = ((Integer) argument1).intValue();
				final double solidZ = ((Double) argument2).doubleValue();
				yIterationBlock.value_(new StBlockClosure() {
					public Object value_value_(Object argument1, Object argument2) {
						final int mediumY = ((Integer) argument1).intValue();
						final double solidY = ((Double) argument2).doubleValue();
						xIterationBlock.value_(new StBlockClosure() {
							public Object value_value_(Object argument1, Object argument2) {
								final int mediumX = ((Integer) argument1).intValue();
								final double solidX = ((Double) argument2).doubleValue();

								if (aJunSolid_.containsPoint_(new Jun3dPoint(solidX, solidY, solidZ))) {
									this_.medium().atX_y_z_put_(mediumX, mediumY, mediumZ, paint_);
								}

								return null;
							}
						});

						return null;
					}
				});

				return null;
			}
		});
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dImage
	 */
	public Jun3dImage medium() {
		return this.medium;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dPoint
	 */
	public Jun3dPoint offset() {
		return this.offset;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dPoint
	 */
	public void offset_(Jun3dPoint aJun3dPoint) {
		this.offset = aJun3dPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Color
	 */
	public Color paint() {
		return this.paint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aColor
	 */
	public void paint(Color aColor) {
		this.paint = aColor;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Jun3dPoint
	 */
	public Jun3dPoint scale() {
		return this.scale;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dPoint
	 */
	public void scale_(Jun3dPoint aJun3dPoint) {
		this.scale = aJun3dPoint;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param aJun3dImage
	 */
	public void setMedium_(Jun3dImage aJun3dImage) {
		this.medium = aJun3dImage;
		this.clippingBounds = this.defaultClippingBounds();
		this.paint = this.defaultPaint();
		this.offset = this.defaultOffset();
		this.scale = this.defaultScale();
	}

}
