package jp.co.sra.jun.threeDImage.colors;

import java.awt.Color;
import java.lang.Math;
import jp.co.sra.smalltalk.StColorValue;

/**
 * JunColorValue class
 * 
 *  @author    kondo
 *  @created   1999/09/07 (by kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorValue.java,v 8.10 2008/02/20 06:33:00 nisinaka Exp $
 */
public class JunColorValue {
	private static final int MaxValue = 255;

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param thisColor
	 * @param aColor DOCUMENT ME!
	 * 
	 * @return Color
	 */
	public static Color BlendOver_(Color thisColor, Color aColor) {
		int alpha0 = StColorValue._GetAlpha(thisColor);

		if (alpha0 == 0) {
			return aColor;
		}

		int alpha1 = (StColorValue._GetAlpha(aColor) * (MaxValue - alpha0)) / MaxValue;

		if (alpha1 == 0) {
			return thisColor;
		}

		int alphaSum = alpha0 + alpha1;
		int blendRed = (thisColor.getRed() * alpha0 + (aColor.getRed() * alpha1)) / alphaSum;
		int blendGreen = (thisColor.getGreen() * alpha0 + (aColor.getGreen() * alpha1)) / alphaSum;
		int blendBlue = (thisColor.getBlue() * alpha0 + (aColor.getBlue() * alpha1)) / alphaSum;
		int blendAlpha = Math.min(alphaSum, MaxValue);

		return StColorValue._NewColor(blendRed, blendGreen, blendBlue, blendAlpha);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param thisColor
	 * @param aColor DOCUMENT ME!
	 * 
	 * @return Color
	 */
	public static Color BlendUnder_(Color thisColor, Color aColor) {
		return BlendOver_(aColor, thisColor);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param thisColor
	 * @param aColor DOCUMENT ME!
	 * 
	 * @return Color
	 */
	public static Color BlendWith_(Color thisColor, Color aColor) {
		int alpha0 = StColorValue._GetAlpha(thisColor);
		int alpha1 = StColorValue._GetAlpha(aColor);
		int alphaSum = alpha0 + alpha1;
		int blendRed = (thisColor.getRed() * alpha0 + (aColor.getRed() * alpha1)) / alphaSum;
		int blendGreen = (thisColor.getGreen() * alpha0 + (aColor.getGreen() * alpha1)) / alphaSum;
		int blendBlue = (thisColor.getBlue() * alpha0 + (aColor.getBlue() * alpha1)) / alphaSum;
		int blendAlpha = Math.min(alphaSum, MaxValue);

		return StColorValue._NewColor(blendRed, blendGreen, blendBlue, blendAlpha);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param thisColor
	 * 
	 * @return boolean
	 */
	public static boolean IsSolid_(Color thisColor) {
		return StColorValue._GetAlpha(thisColor) == MaxValue;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param thisColor
	 * 
	 * @return boolean
	 */
	public static boolean IsTransparent_(Color thisColor) {
		return StColorValue._GetAlpha(thisColor) == 0;
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @return Color
	 */
	public static Color Transparent() {
		return StColorValue._NewColor(1.0f, 1.0f, 1.0f, 0.0f);
	}
}
