package jp.co.sra.jun.terrain.display;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;

/**
 * JunTerrainProjection class
 * 
 *  @author    nisinaka
 *  @created   2002/01/22 (by nisinaka)
 *  @updated   2004/10/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTerrainProjection.java,v 8.11 2008/02/20 06:32:59 nisinaka Exp $
 */
public class JunTerrainProjection extends JunOpenGLPerspectiveProjection {

	/**
	 * Set my new eye point.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @see jp.co.sra.jun.opengl.projection.JunOpenGLProjection#eyePoint_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category accessing
	 */
	public void eyePoint_(Jun3dPoint a3dPoint) {
		eyePoint = a3dPoint;
		this.normalizeUpVector();
	}

	/**
	 * Set my new sight point.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @see jp.co.sra.jun.opengl.projection.JunOpenGLProjection#sightPoint_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category accessing
	 */
	public void sightPoint_(Jun3dPoint a3dPoint) {
		sightPoint = a3dPoint;
		this.normalizeUpVector();
	}

}
