package jp.co.sra.jun.terrain.display;

import java.awt.Component;
import java.awt.event.MouseEvent;

import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmController;

/**
 * JunTerrainDisplayController class
 * 
 *  @author    nisinaka
 *  @created   2002/01/22 (by nisinaka)
 *  @updated   2007/08/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTerrainDisplayController.java,v 8.11 2008/02/20 06:32:59 nisinaka Exp $
 */
public class JunTerrainDisplayController extends JunOpenGLMicrocosmController {

	/**
	 * Invoked when a mouse is entered on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayController#mouseEntered(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseEntered(MouseEvent e) {
		StSymbol state = ((JunTerrainDisplayModel) this.model()).buttonState();
		if (state == null) {
			return;
		}

		Component aComponent = this.getOpenGLDrawable().toComponent();
		_savedCursor = aComponent.getCursor();

		if (state == $("pick")) {
			aComponent.setCursor(JunCursors.CrossCursor());
		} else if (state == $("grab")) {
			aComponent.setCursor(JunCursors.ReadCursor());
		} else if (state == $("drag")) {
			aComponent.setCursor(JunCursors.QuartersCursor());
		} else if (state == $("focus")) {
			aComponent.setCursor(JunCursors.GlassCursor());
		}
	}

}
