package jp.co.sra.jun.system.support;

import jp.co.sra.smalltalk.*;

/**
 * JunSmallTypeTable class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   2003/05/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSmallTypeTable.java,v 8.10 2008/02/20 06:32:59 nisinaka Exp $
 */
public class JunSmallTypeTable extends StObject {

	/** The single instance of JunSmallTypeTable. */
	protected static JunSmallTypeTable TypeTable;

	/** The array which holds the type table. */
	protected static StSymbol[] _TypeTable = null;
	protected StSymbol value0;
	protected StSymbol defaultValue;
	protected StSymbol letterValue;
	protected StSymbol digitValue;
	protected StSymbol separatorValue;

	/**
	 * Initialize the type table.
	 * 
	 * @return jp.co.sra.jun.system.support.JunSmallTypeTable
	 */
	public static JunSmallTypeTable TypeTable() {
		if (TypeTable == null) {
			TypeTable = new JunSmallTypeTable();
			_TypeTable = new StSymbol[256];
			TypeTable.atAllPut_($("xDefault"));
			TypeTable.atAllSeparatorsPut_($("xDelimiter"));
			TypeTable.atAllDigitsPut_($("xDigit"));
			TypeTable.atAllLettersPut_($("xLetter"));
			_TypeTable['_'] = $("xLetter");
			_TypeTable['!'] = $("xBinary");
			_TypeTable['%'] = $("xBinary");
			_TypeTable['&'] = $("xBinary");
			_TypeTable['*'] = $("xBinary");
			_TypeTable['+'] = $("xBinary");
			_TypeTable[','] = $("xBinary");
			_TypeTable['-'] = $("xBinary");
			_TypeTable['/'] = $("xBinary");
			_TypeTable['<'] = $("xBinary");
			_TypeTable['='] = $("xBinary");
			_TypeTable['>'] = $("xBinary");
			_TypeTable['?'] = $("xBinary");
			_TypeTable['@'] = $("xBinary");
			_TypeTable['\\'] = $("xBinary");
			_TypeTable['~'] = $("xBinary");
			_TypeTable[177] = $("xBinary");
			_TypeTable[215] = $("xBinary");
			_TypeTable[183] = $("xBinary");
			_TypeTable[247] = $("xBinary");
			_TypeTable['"'] = $("xDoubleQuote");
			_TypeTable['$'] = $("xDollar");
			_TypeTable['\''] = $("xSingleQuote");
			_TypeTable['#'] = $("literalQuote");
			_TypeTable['('] = $("leftParenthesis");
			_TypeTable[')'] = $("rightParenthesis");
			_TypeTable['.'] = $("period");
			_TypeTable[':'] = $("colon");
			_TypeTable[';'] = $("semicolon");
			_TypeTable['['] = $("leftBracket");
			_TypeTable[']'] = $("rightBracket");
			_TypeTable['^'] = $("upArrow");
			_TypeTable['|'] = $("verticalBar");
		}

		return TypeTable;
	}

	/**
	 * Answer the value of the table element specified with the index.
	 * 
	 * @param index int
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public StSymbol at_(int index) {
		if (index == 0) {
			return value0;
		}

		if (Character.isLetter((char) index)) {
			return letterValue;
		}

		if (Character.isWhitespace((char) index)) {
			return separatorValue;
		}

		if (Character.isDigit((char) index)) {
			return digitValue;
		}

		try {
			return _TypeTable[index];
		} catch (Exception e) {
			return defaultValue;
		}
	}

	/**
	 * Set the value of the table element specified with the index.
	 * 
	 * @param index int
	 * @param value jp.co.sra.smalltalk.StSymbol
	 */
	public void at_put_(int index, StSymbol value) {
		if (index == 0) {
			value0 = value;
			return;
		}

		if (value == this.at_(index)) {
			return;
		}

		_TypeTable[index] = value;
	}

	/**
	 * Set the value for all the digits.
	 * 
	 * @param value jp.co.sra.smalltalk.StSymbol
	 */
	public void atAllDigitsPut_(StSymbol value) {
		digitValue = value;
		for (int index = 0; index <= this.size(); index++) {
			if (Character.isDigit((char) index)) {
				this.at_put_(index, value);
			}
		}
	}

	/**
	 * Set the value for all the letters.
	 * 
	 * @param value jp.co.sra.smalltalk.StSymbol
	 */
	public void atAllLettersPut_(StSymbol value) {
		letterValue = value;
		for (int index = 0; index <= this.size(); index++) {
			if (Character.isLetter((char) index)) {
				this.at_put_(index, value);
			}
		}
	}

	/**
	 * Put the value for all of the table elements.
	 * 
	 * @param value jp.co.sra.smalltalk.StSymbol
	 */
	public void atAllPut_(StSymbol value) {
		value0 = value;
		defaultValue = value;
		letterValue = value;
		digitValue = value;
		separatorValue = value;
		for (int i = 0; i < this.size(); i++) {
			this.at_put_(i, value);
		}
	}

	/**
	 * Set the value for all the separators.
	 * 
	 * @param value jp.co.sra.smalltalk.StSymbol
	 */
	public void atAllSeparatorsPut_(StSymbol value) {
		separatorValue = value;
		for (int index = 0; index <= this.size(); index++) {
			if (Character.isWhitespace((char) index)) {
				this.at_put_(index, value);
			}
		}
	}

	/**
	 * Set the value as a default value.
	 * 
	 * @param value jp.co.sra.smalltalk.StSymbol
	 */
	public void atDefaultPut_(StSymbol value) {
		defaultValue = value;
	}

	/**
	 * Answer the size of the type table.
	 * 
	 * @return int
	 */
	public int size() {
		return _TypeTable.length;
	}
}
