package jp.co.sra.jun.system.framework;

import java.awt.Graphics;

import jp.co.sra.smalltalk.StViewJPanel;

/**
 * JunAbstractViewJPanel class
 * 
 *  @author    nisinaka
 *  @created   2004/09/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun579 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractViewJPanel.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public abstract class JunAbstractViewJPanel extends StViewJPanel implements JunAbstractView {

	/**
	 * Create a new instance of JunAbstractViewJPanel.
	 * 
	 * @category Instance creation
	 */
	public JunAbstractViewJPanel() {
		super();
	}

	/**
	 * Create a new instance of JunAbstractViewJPanel.
	 * 
	 * @param newModel jp.co.sra.jun.system.framework.JunApplicationModel
	 * @category Instance creation
	 */
	public JunAbstractViewJPanel(JunApplicationModel newModel) {
		super(newModel);
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphicsContext) {
		if (this.model() instanceof JunAbstractModel) {
			((JunAbstractModel) this.model()).displayOn_(aGraphicsContext);
		}
	}
}
