package jp.co.sra.jun.system.framework;

import java.awt.event.MouseEvent;

import javax.swing.SwingUtilities;

import jp.co.sra.smalltalk.StController;

/**
 * JunAbstractController class
 * 
 *  @author    nisinaka
 *  @created   2004/09/21 (by nisinaka)
 *  @updated   2007/09/11 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun505 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractController.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunAbstractController extends StController {

	/**
	 * The mouse button has been pressed.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(java.awt.event.MouseEvent)
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.yellowButtonActivity(e);
		} else if (SwingUtilities.isLeftMouseButton(e)) {
			this.redButtonPressedActivity(e);
		}
	}

	/**
	 * The mouse button has been released.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseReleased(java.awt.event.MouseEvent)
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.yellowButtonActivity(e);
		} else if (SwingUtilities.isLeftMouseButton(e)) {
			this.redButtonReleasedActivity(e);
		}
	}

	/**
	 * Activity for the red button pressed.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void redButtonPressedActivity(MouseEvent e) {
		// The subclasses may override.
	}

	/**
	 * Activity for the red button released.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void redButtonReleasedActivity(MouseEvent e) {
		// The subclasses may override.
	}

	/**
	 * Activity for the yellow button.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @category control defaults
	 */
	protected void yellowButtonActivity(MouseEvent e) {
		this.view()._showPopupMenu(e.getX(), e.getY());
	}

}
