package jp.co.sra.jun.solid.abstracts;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.threeDImage.support.Jun3dGraphicsContext;

/**
 * JunSolidModel class
 * 
 *  @author    kondo
 *  @created   1999/09/08 (by kondo)
 *  @updated   1999/10/18 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun533 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSolidModel.java,v 8.11 2008/02/20 06:32:50 nisinaka Exp $
 */
public abstract class JunSolidModel extends JunAbstractObject {
	/**
	 * Answer true if the receiver contains the specified point, otherwise false.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return boolean
	 * @category testing
	 */
	public abstract boolean containsPoint_(Jun3dPoint a3dPoint);

	/**
	 * Display the receiver on a specified graphics context.
	 * 
	 * @param aGraphicsContext jp.co.sra.jun.threeDImage.support.Jun3dGraphicsContext
	 * @category displaying
	 */
	public void displayOn_(Jun3dGraphicsContext aGraphicsContext) {
		aGraphicsContext.displaySolid_at_(this, Jun3dPoint.Zero());
	}

	/**
	 * Display the receiver on a specified graphics context.
	 * 
	 * @param aGraphicsContext jp.co.sra.jun.threeDImage.support.Jun3dGraphicsContext
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category displaying
	 */
	public void displayOn_at_(Jun3dGraphicsContext aGraphicsContext, Jun3dPoint aJun3dPoint) {
		aGraphicsContext.displaySolid_at_(this, aJun3dPoint);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return double
	 * @category accessing
	 */
	public abstract double valueAt_(Jun3dPoint aJun3dPoint);
}
