package jp.co.sra.jun.opengl.support;

import java.awt.Graphics;

/**
 * JunOpenGLRenderer interface
 * 
 *  @author    nisinaka
 *  @created   2007/08/23 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRenderer.java,v 8.4 2008/02/20 06:32:49 nisinaka Exp $
 */
public interface JunOpenGLRenderer {

	/**
	 * Render the receiver on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext);

	/**
	 * Superimpose on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @param aDrawable jp.co.sra.jun.opengl.support.JunOpenGLDrawable
	 * @category superimpose
	 */
	public void superimposeOn_(Graphics aGraphics, JunOpenGLDrawable aDrawable);

}
