package jp.co.sra.jun.opengl.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.gl4jun.GLjRenderingMode;

/**
 * JunGLImage class
 * 
 *  @author    nisinaka
 *  @created   2007/08/23 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGLImage.java,v 8.4 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunGLImage extends StImage implements JunOpenGLDrawable {

	protected JunOpenGLRenderer renderer;
	protected Color background;

	/**
	 * Create a new instance of JunGLImage and initialize it.
	 *
	 * @param width int
	 * @param height int
	 * @category Instance creation
	 */
	public JunGLImage(int width, int height) {
		this(null, width, height, Color.white);
	}

	/**
	 * 
	 * Create a new instance of JunGLImage and initialize it.
	 *
	 * @param anOpenGLRenderer jp.co.sra.jun.opengl.support.JunOpenGLRenderer
	 * @param width int
	 * @param height int
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunGLImage(JunOpenGLRenderer anOpenGLRenderer, int width, int height, Color aColor) {
		super(width, height);
		background = aColor;
		this.setRenderer(anOpenGLRenderer);
	}

	/**
	 * Answer my current OpenGL interface.
	 * 
	 * @return jp.co.sra.jun.opengl.support.JunOpenGLInterface
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#getOpenGLInterface()
	 * @category accessing 
	 */
	public JunOpenGLInterface getOpenGLInterface() {
		return JunGLInterface.Current;
	}

	/**
	 * Answer my current size.
	 * 
	 * @return java.awt.Dimension
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#getSize()
	 * @category accessing
	 */
	public Dimension getSize() {
		return new Dimension(this.width(), this.height());
	}

	/**
	 * Answer my current background color.
	 * 
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#getBackgroundColor()
	 * @category accessing
	 */
	public Color getBackgroundColor() {
		return background;
	}

	/**
	 * Set my new renderer.
	 * 
	 * @param anOpenGLRenderer jp.co.sra.jun.opengl.support.JunOpenGLRenderer
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#setRenderer(jp.co.sra.jun.opengl.support.JunOpenGLRenderer)
	 * @category accessing
	 */
	public void setRenderer(JunOpenGLRenderer anOpenGLRenderer) {
		if (renderer == anOpenGLRenderer) {
			return;
		}

		renderer = anOpenGLRenderer;
		this.redisplay();
	}

	/**
	 * Convert to a component.
	 * 
	 * @return java.awt.Component
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#toComponent()
	 * @category converting
	 */
	public Component toComponent() {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * Render the receiver on the rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
		if (renderer != null) {
			renderer.renderOn_(aRenderingContext);
		}
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @param aPoint java.awt.Point
	 * @see jp.co.sra.smalltalk.StImage#displayOn_at_(java.awt.Graphics, java.awt.Point)
	 * @category displaying
	 */
	public void displayOn_at_(Graphics aGraphics, Point aPoint) {
		synchronized (JunGLInterface.Current) {
			int handle = -1;
			try {
				handle = JunGLInterface.Current.gljCreateContext(null, this.width(), this.height(), GLjRenderingMode.IMAGE);
				JunGLInterface.Current.gljMakeCurrent(handle);

				JunOpenGLRenderingContext renderingContext = new JunOpenGLRenderingContext(this);
				this.renderOn_(renderingContext);

				int width = this.width();
				int height = this.height();
				int[] pixels = new int[width * height];
				JunGLInterface.Current.gljReadImage(handle, pixels, false);
				MemoryImageSource memoryImageSource = new MemoryImageSource(width, height, pixels, 0, width);
				Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);

				aGraphics.drawImage(image, aPoint.x, aPoint.y, null);

			} finally {
				if (handle >= 0) {
					JunGLInterface.Current.gljFlushBuffer(handle);
					JunGLInterface.Current.gljDeleteContext(handle, false);
				}
			}
		}
	}

	/**
	 * Display the entire contents again.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#redisplay()
	 * @category displaying
	 */
	public void redisplay() {
		Graphics g = null;
		try {
			g = this.image().getGraphics();
			this.displayOn_(g);
		} finally {
			if (g != null) {
				g.dispose();
			}
		}
	}

	/**
	 * Display the entire contents again immediately.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLDrawable#redisplayImmediately()
	 * @category displaying
	 */
	public void redisplayImmediately() {
		this.redisplay();
	}

}
