package jp.co.sra.jun.opengl.support;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/**
 * JOGLInterface class
 * 
 *  @author    nisinaka
 *  @created   2007/08/20 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JOGLInterface.java,v 8.3 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JOGLInterface extends JunOpenGLInterface {

	protected GL gl;
	protected GLU glu;

	/**
	 * Create a new instance of JOGLInterface and initialize it.
	 *
	 * @param gl javax.media.opengl.GL
	 * @category Instance creation
	 */
	protected JOGLInterface(GL gl) {
		this.gl = gl;
		glu = new GLU();
	}

	/**
	 * Answer the current interface.
	 * 
	 * @return javax.media.opengl.GL
	 * @category accessing
	 */
	protected GL getInterface() {
		return gl;
	}

	/**
	 * Set the mode to begin.
	 * 
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glBegin(int)
	 * @category gl procedures
	 */
	public void glBegin(int mode) {
		this.getInterface().glBegin(mode);
	}

	/**
	 * Set the blend function.
	 * 
	 * @param sfactor int
	 * @param dfactor int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glBlendFunc(int, int)
	 * @category gl procedures
	 */
	public void glBlendFunc(int sfactor, int dfactor) {
		this.getInterface().glBlendFunc(sfactor, dfactor);
	}

	/**
	 * Call the display list.
	 * 
	 * @param listId int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glCallList(int)
	 * @category gl procedures
	 */
	public void glCallList(int listId) {
		this.getInterface().glCallList(listId);
	}

	/**
	 * Clear the mask.
	 * 
	 * @param mask int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glClear(int)
	 * @category gl procedures
	 */
	public void glClear(int mask) {
		this.getInterface().glClear(mask);
	}

	/**
	 * Clear the color.
	 * 
	 * @param r float
	 * @param g float
	 * @param b float
	 * @param a float
	 * @see jp.co.sra.jun.openthis.getInterface().support.JunOpenGLInterface#glClearColor(float, float, float, float)
	 * @category gl procedures
	 */
	public void glClearColor(float r, float g, float b, float a) {
		this.getInterface().glClearColor(r, g, b, a);
	}

	/**
	 * Set glColor4f.
	 * 
	 * @param r float
	 * @param g float
	 * @param b float
	 * @param a float
	 * @see jp.co.sra.jun.openthis.getInterface().support.JunOpenGLInterface#glColor4f(float, float, float, float)
	 * @category gl procedures
	 */
	public void glColor4f(float r, float g, float b, float a) {
		this.getInterface().glColor4f(r, g, b, a);
	}

	/**
	 * Set the cull face mode.
	 * 
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glCullFace(int)
	 * @category gl procedures
	 */
	public void glCullFace(int mode) {
		this.getInterface().glCullFace(mode);
	}

	/**
	 * Set the status of the depth mask.
	 * 
	 * @param flag boolean
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glDepthMask(boolean)
	 * @category gl procedures
	 */
	public void glDepthMask(boolean flag) {
		this.getInterface().glDepthMask(flag);
	}

	/**
	 * Disable the capability.
	 * 
	 * @param cap int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glDisable(int)
	 * @category gl procedures
	 */
	public void glDisable(int cap) {
		this.getInterface().glDisable(cap);
	}

	/**
	 * Enable the capability.
	 * 
	 * @param cap int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glEnable(int)
	 * @category gl procedures
	 */
	public void glEnable(int cap) {
		this.getInterface().glEnable(cap);
	}

	/**
	 * Set the current mode to end.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glEnd()
	 * @category gl procedures
	 */
	public void glEnd() {
		this.getInterface().glEnd();
	}

	/**
	 * End the current display list.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glEndList()
	 * @category gl procedures
	 */
	public void glEndList() {
		this.getInterface().glEndList();
	}

	/**
	 * Flush the buffer.
	 * 
	 * @see jp.co.sra.jun.openthis.getInterface().support.JunOpenGLInterface#glFlush()
	 * @category gl procedures
	 */
	public void glFlush() {
		this.getInterface().glFlush();
	}

	/**
	 * Generate a display list.
	 * 
	 * @param range int
	 * @return int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glGenLists(int)
	 * @category gl procedures
	 */
	public int glGenLists(int range) {
		return this.getInterface().glGenLists(range);
	}

	/**
	 * Set the hint.
	 * 
	 * @param target int
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glHint(int, int)
	 * @category gl procedures
	 */
	public void glHint(int target, int mode) {
		this.getInterface().glHint(target, mode);
	}

	/**
	 * Set light source parameters.
	 * 
	 * @param light int
	 * @param pname int
	 * @param param float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLightf(int, int, float)
	 * @category gl procedures
	 */
	public void glLightf(int light, int pname, float param) {
		this.getInterface().glLightf(light, pname, param);
	}

	/**
	 * Set light source parameters.
	 * 
	 * @param light int
	 * @param pname int
	 * @param params float[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLightfv(int, int, float[])
	 * @category gl procedures
	 */
	public void glLightfv(int light, int pname, float[] params) {
		this.getInterface().glLightfv(light, pname, params, 0);
	}

	/**
	 * Set the lighting model parameters. 
	 * 
	 * @param pname int
	 * @param param float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLightModelf(int, float)
	 * @category gl procedures
	 */
	public void glLightModelf(int pname, float param) {
		this.getInterface().glLightModelf(pname, param);
	}

	/**
	 * Set the lighting model parameters. 
	 * 
	 * @param pname int
	 * @param params float[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLightModelfv(int, float[])
	 * @category gl procedures
	 */
	public void glLightModelfv(int pname, float[] params) {
		this.getInterface().glLightModelfv(pname, params, 0);
	}

	/**
	 * Set the line stipple factor and pattern.
	 * 
	 * @param factor int
	 * @param pattern short
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLineStipple(int, short)
	 * @category gl procedures
	 */
	public void glLineStipple(int factor, short pattern) {
		this.getInterface().glLineStipple(factor, pattern);
	}

	/**
	 * Set the line width.
	 * 
	 * @param width float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLineWidth(float)
	 * @category gl procedures
	 */
	public void glLineWidth(float width) {
		this.getInterface().glLineWidth(width);
	}

	/**
	 * Load the identity.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLoadIdentity()
	 * @category gl procedures
	 */
	public void glLoadIdentity() {
		this.getInterface().glLoadIdentity();
	}

	/**
	 * Specify the material.
	 * 
	 * @param face int
	 * @param pname int
	 * @param param int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glMaterialf(int, int, float)
	 * @category gl procedures
	 */
	public void glMaterialf(int face, int pname, float param) {
		this.getInterface().glMaterialf(face, pname, param);
	}

	/**
	 * Specify the material.
	 * 
	 * @param face int
	 * @param pname int
	 * @param params float[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glMaterialfv(int, int, float[])
	 * @category gl procedures
	 */
	public void glMaterialfv(int face, int pname, float[] params) {
		this.getInterface().glMaterialfv(face, pname, params, 0);
	}

	/**
	 * Set the matrix mode.
	 * 
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glMatrixMode(int)
	 * @category gl procedures
	 */
	public void glMatrixMode(int mode) {
		this.getInterface().glMatrixMode(mode);
	}

	/**
	 * Multiply the current matrix with the specified matrix.
	 * 
	 * @param matrix double[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glMultMatrixd(double[])
	 * @category gl procedures
	 */
	public void glMultMatrixd(double[] matrix) {
		this.getInterface().glMultMatrixd(matrix, 0);
	}

	/**
	 * Create a new display list with the mode.
	 * 
	 * @param list int
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glNewList(int, int)
	 * @category gl procedures
	 */
	public void glNewList(int list, int mode) {
		this.getInterface().glNewList(list, mode);
	}

	/**
	 * Set the normal vector.
	 * 
	 * @param x double
	 * @param y double
	 * @param z double
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glNormal3d(double, double, double)
	 * @category gl procedures
	 */
	public void glNormal3d(double x, double y, double z) {
		this.getInterface().glNormal3d(x, y, z);
	}

	/**
	 * Set the ortho.
	 * 
	 * @param left double
	 * @param right double
	 * @param bottom double
	 * @param top double
	 * @param near double
	 * @param far double
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glOrtho(double, double, double, double, double, double)
	 * @category gl procedures 
	 */
	public void glOrtho(double left, double right, double bottom, double top, double near, double far) {
		this.getInterface().glOrtho(left, right, bottom, top, near, far);
	}

	/**
	 * Set the pixel store.
	 * 
	 * @param panem int
	 * @param param int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPixelStorei(int, int)
	 * @category gl procedures
	 */
	public void glPixelStorei(int pname, int param) {
		this.getInterface().glPixelStorei(pname, param);
	}

	/**
	 * Set the point size.
	 * 
	 * @param size float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPointSize(float)
	 * @category gl procedures
	 */
	public void glPointSize(float size) {
		this.getInterface().glPointSize(size);
	}

	/**
	 * Set the polygon mode.
	 * 
	 * @param face int
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPolygonMode(int, int)
	 * @category gl procedures
	 */
	public void glPolygonMode(int face, int mode) {
		this.getInterface().glPolygonMode(face, mode);
	}

	/**
	 * Set the polygon offset.
	 * 
	 * @param factor int
	 * @param units int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPolygonOffset(float, float)
	 * @category gl procedures
	 */
	public void glPolygonOffset(float factor, float units) {
		this.getInterface().glPolygonOffset(factor, units);
	}

	/**
	 * Set the polygon stipple.
	 * 
	 * @param mask byte[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPolygonStipple(byte[])
	 * @category gl procedures
	 */
	public void glPolygonStipple(byte[] mask) {
		this.getInterface().glPolygonStipple(mask, 0);
	}

	/**
	 * Pop the matrix.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPopMatrix()
	 * @category gl procedures
	 */
	public void glPopMatrix() {
		this.getInterface().glPopMatrix();
	}

	/**
	 * Push the matrix.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPushMatrix()
	 * @category gl procedures
	 */
	public void glPushMatrix() {
		this.getInterface().glPushMatrix();
	}

	/**
	 * Set the shade model.
	 * 
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glShadeModel(int)
	 * @category gl procedures
	 */
	public void glShadeModel(int mode) {
		this.getInterface().glShadeModel(mode);
	}

	/**
	 * Set the texture coordinate.
	 * 
	 * @param s double
	 * @param t double
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glTexCoord2d(double, double)
	 * @category gl procedures
	 */
	public void glTexCoord2d(double s, double t) {
		this.getInterface().glTexCoord2d(s, t);
	}

	/**
	 * Set the texture environment.
	 * 
	 * @param target int
	 * @param pname int
	 * @param param int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glTexEnvi(int, int, int)
	 * @category gl procedures
	 */
	public void glTexEnvi(int target, int pname, int param) {
		this.getInterface().glTexEnvi(target, pname, param);
	}

	/**
	 * Control the generation of texture coordinates.
	 * 
	 * @param coord int
	 * @param pname int
	 * @param params float[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glTexGenfv(int, int, float[])
	 * @category gl procedures
	 */
	public void glTexGenfv(int coord, int pname, float[] params) {
		this.getInterface().glTexGenfv(coord, pname, params, 0);
	}

	/**
	 * Control the generation of texture coordinates.
	 * 
	 * @param target int
	 * @param pname int
	 * @param param int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glTexGeni(int, int, int)
	 * @category gl procedures
	 */
	public void glTexGeni(int target, int pname, int param) {
		this.getInterface().glTexGeni(target, pname, param);
	}

	/**
	 * Set the texture image.
	 * 
	 * @param target int
	 * @param level int
	 * @param components int
	 * @param width int
	 * @param height height
	 * @param border int
	 * @param format int
	 * @param type int
	 * @param pixels byte[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glTexImage2D(int, int, int, int, int, int, int, int, byte[])
	 * @category gl procedures
	 */
	public void glTexImage2D(int target, int level, int components, int width, int height, int border, int format, int type, byte[] pixels) {
		this.getInterface().glTexImage2D(target, level, components, width, height, border, format, type, ByteBuffer.wrap(pixels));
	}

	/**
	 * Set the texture parameter.
	 * 
	 * @param target int
	 * @param pname int
	 * @param param int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glTexParameteri(int, int, int)
	 * @category gl procedures
	 */
	public void glTexParameteri(int target, int pname, int param) {
		this.getInterface().glTexParameteri(target, pname, param);
	}

	/**
	 * Set the curve to begin.
	 * 
	 * @param nurbs int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluBeginCurve(int)
	 * @category glu procedures
	 */
	public void gluBeginCurve(int nurbs) {
		//glu.gluBeginCurve(nurbs);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the surface to begin.
	 * 
	 * @param nurbs int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluBeginSurface(int)
	 * @category glu procedures
	 */
	public void gluBeginSurface(int nurbs) {
		//glu.gluBeginSurface(nurbs);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Builds a 2D mipmap.
	 * 
	 * @param target int
	 * @param components int
	 * @param width int
	 * @param height int
	 * @param format int
	 * @param type int
	 * @param data byte[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluBuild2DMipmaps(int, int, int, int, int, int, byte[])
	 * @category glu procedures
	 */
	public void gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, byte[] data) {
		glu.gluBuild2DMipmaps(target, components, width, height, format, type, ByteBuffer.wrap(data));
	}

	/**
	 * Delete the nurbs renderer.
	 * 
	 * @param nurbs int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluDeleteNurbsRenderer(int)
	 * @category glu procedures
	 */
	public void gluDeleteNurbsRenderer(int nurbs) {
		//glu.gluDeleteNurbsRenderer(nurbs);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the curve to end.
	 * 
	 * @param nurbs int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluEndCurve(int)
	 * @category glu procedures
	 */
	public void gluEndCurve(int nurbs) {
		//glu.gluEndCurve(nurbs);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the surface to end.
	 * 
	 * @param nurbs int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluEndSurface(int)
	 * @category glu procedures
	 */
	public void gluEndSurface(int nurbs) {
		//glue.gluEndSurface(nurbs);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the projection.
	 * 
	 * @param eyePointX double
	 * @param eyePointY double
	 * @param eyePointZ double
	 * @param sightPointX double
	 * @param sightPointY double
	 * @param sightPointZ double
	 * @param upVectorX double
	 * @param upVectorY double
	 * @param upVectorZ double
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluLookAt(double, double, double, double, double, double, double, double, double)
	 * @category glu procedures
	 */
	public void gluLookAt(double eyePointX, double eyePointY, double eyePointZ, double sightPointX, double sightPointY, double sightPointZ, double upVectorX, double upVectorY, double upVectorZ) {
		glu.gluLookAt(eyePointX, eyePointY, eyePointZ, sightPointX, sightPointY, sightPointZ, upVectorX, upVectorY, upVectorZ);
	}

	/**
	 * Create a new nurbs renderer.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluNewNurbsRenderer()
	 * @category glu procedures
	 */
	public int gluNewNurbsRenderer() {
		//return glu.gluNewNurbsRenderer();
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the nurbs curve.
	 * 
	 * @param nurbs int
	 * @param nknots int
	 * @param knot float[]
	 * @param stride int
	 * @param ctlarray float[]
	 * @param order int
	 * @param type int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluNurbsCurve(int, int, float[], int, float[], int, int)
	 * @category glu procedures
	 */
	public void gluNurbsCurve(int nurbs, int nknots, float[] knot, int stride, float[] ctlarray, int order, int type) {
		//glu.gluNurbsCurve(nurbs, nknots, knot, stride, ctlarray, order, type);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the nurbs property.
	 * 
	 * @param nurbs int
	 * @param property int
	 * @param value float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluNurbsProperty(int, int, float)
	 * @category glu procedures
	 */
	public void gluNurbsProperty(int nurbs, int property, float value) {
		//glu.gluNurbsProperty(nurbs, property, value);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the nurbs surface.
	 * 
	 * @param nurbs int
	 * @param sknot_count int
	 * @param sknot float[]
	 * @param tknot_count int
	 * @param tknot float[]
	 * @param s_stride int
	 * @param t_strinde int
	 * @param ctlarray float[]
	 * @param sorder int
	 * @param torder int
	 * @param type int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluNurbsSurface(int, int, float[], int, float[], int, int, float[], int, int, int)
	 * @category glu procedures
	 */
	public void gluNurbsSurface(int nurbs, int sknot_count, float[] sknot, int tknot_count, float[] tknot, int s_stride, int t_stride, float[] ctlarray, int sorder, int torder, int type) {
		//glu.gluNurbsSurface(nurbs, sknot_count, sknot, tknot_count, tknot, s_stride, t_stride, ctlarray, sorder, torder, type);
		throw new RuntimeException("The GLU NURBS routines are not currently exposed.");
	}

	/**
	 * Set the perspective projection.
	 * 
	 * @param fovy double
	 * @param aspect double
	 * @param near double
	 * @param far double
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#gluPerspective(double, double, double, double)
	 * @category glu procedures
	 */
	public void gluPerspective(double fovy, double aspect, double near, double far) {
		glu.gluPerspective(fovy, aspect, near, far);
	}

	/**
	 * Set the vertex.
	 * 
	 * @param x double
	 * @param y double
	 * @param z double
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glVertex3d(double, double, double)
	 * @category gl procedures
	 */
	public void glVertex3d(double x, double y, double z) {
		this.getInterface().glVertex3d(x, y, z);
	}

	/**
	 * Load a name onto the name stack.
	 * 
	 * @param name int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glLoadName(int)
	 * @category gl procedures
	 */
	public void glLoadName(int name) {
		this.getInterface().glLoadName(name);
	}

	/**
	 * Specify fog parameter.
	 * 
	 * @param pname int
	 * @param param float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glFogf(int, float)
	 * @category gl procedures
	 */
	public void glFogf(int pname, float param) {
		this.getInterface().glFogf(pname, param);

	}

	/**
	 * Specify fog parameters.
	 * 
	 * @param pname int
	 * @param params float[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glFogfv(int, float[])
	 * @category gl procedures
	 */
	public void glFogfv(int pname, float[] params) {
		this.getInterface().glFogfv(pname, params, 0);
	}

	/**
	 * Specify fog parameter.
	 * 
	 * @param pname int
	 * @param param int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glFogi(int, int)
	 * @category gl procedures
	 */
	public void glFogi(int pname, int param) {
		this.getInterface().glFogi(pname, param);
	}

	/**
	 * Push the name to the stack. 
	 * 
	 * @param name int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glPushName(int)
	 * @category gl procedures
	 */
	public void glPushName(int name) {
		this.getInterface().glPushName(name);
	}

	/**
	 * Set the rasterization mode.
	 * 
	 * @param mode int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glRenderMode(int)
	 * @category gl procedures
	 */
	public int glRenderMode(int mode) {
		return this.getInterface().glRenderMode(mode);
	}

	/**
	 * Clear the buffer for selection mode values.
	 * 
	 * @param buffer int[]
	 * @param handle int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glSelectBufferEnd(int[], int)
	 * @category gl procedures
	 */
	public void glSelectBufferEnd(int[] buffer, int handle) {
		// 
	}

	/**
	 * Establish a buffer for selection mode values.
	 * 
	 * @param buffer int[]
	 * @return int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLInterface#glSelectBufferStart(int[])
	 * @category gl procedures
	 */
	public int glSelectBufferStart(int[] buffer) {
		this.getInterface().glSelectBuffer(buffer.length, IntBuffer.wrap(buffer));
		return -1;
	}

}
