package jp.co.sra.jun.opengl.rotation;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunOpenGLRotationController class
 * 
 *  @author    nisinaka
 *  @created   1998/12/09 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRotationController.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRotationController extends JunAbstractController implements MouseListener, MouseMotionListener {

	protected Point startPoint;
	protected int startIndex;
	protected Jun2dPoint startVertex;
	protected boolean shiftDown;
	protected boolean moved;
	protected int lastIndex;

	/**
	 * Called when the mouse is dragged.
	 * 
	 * @param event
	 */
	public void mouseDragged(MouseEvent event) {
		if (startPoint == null) {
			return;
		}

		if (shiftDown) {
			this.shiftSelectionActivity_(event);

			return;
		}

		JunOpenGLRotationModel model = (JunOpenGLRotationModel) this.model();
		JunOpenGLRotationView view = (JunOpenGLRotationView) this.view();
		Point startCoord = view.scaledPoint_(this._startVertex());
		Point coord = event.getPoint();
		Jun2dPoint delta = model.descaledPoint_(new Point(coord.x - startCoord.x, coord.y - startCoord.y));

		if (delta.isZero()) {
			return;
		}

		for (int i = 0; i < model.selectedIndices().size(); i++) {
			int each = ((Integer) model.selectedIndices().elementAt(i)).intValue();
			model.vertexAt_put_(each, (Jun2dPoint) model.vertexAt_(each).plus_(delta));
		}

		((Component) view).repaint();
		this._startVertex_(view.descaledPoint_(coord));
		moved = true;
	}

	/**
	 * Invoked when a mouse button has been pressed.
	 * 
	 * @param event java.awt.event.MouseEvent
	 */
	public void mousePressed(MouseEvent event) {
		JunOpenGLRotationView view = (JunOpenGLRotationView) this.view();

		// popup menu
		if (event.isMetaDown()) {
			this.view()._showPopupMenu(event.getX(), event.getY());
			return;
		}

		//
		startPoint = event.getPoint();

		int index = view.scaledVertexIndex_(startPoint);
		this._startIndex_(index);
		this._startVertex_(view.descaledPoint_(startPoint));
		shiftDown = event.isShiftDown();

		if (shiftDown) {
			lastIndex = -1;
			this.shiftSelectionActivity_(event);
			return;
		}

		moved = true;

		if (index >= 0) {
			JunOpenGLRotationModel model = (JunOpenGLRotationModel) this.model();
			if (model.selectedIndices().contains(new Integer(index))) {
				moved = false;
			} else {
				this.selectionActivity_(event);
			}
			return;
		}

		this.creationActivity_(event);
	}

	/**
	 * Invoked when a mouse button has been released.
	 * 
	 * @param event java.awt.event.MouseEvent
	 */
	public void mouseReleased(MouseEvent event) {
		if (!shiftDown && !moved) {
			this.selectionActivity_(event);
		}

		startPoint = null;
	}

	/**
	 * return int
	 * 
	 * @return DOCUMENT ME!
	 */
	private int _startIndex() {
		return startIndex;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param index
	 */
	private void _startIndex_(int index) {
		startIndex = index;
	}

	/**
	 * return Jun2dPoint
	 * 
	 * @return DOCUMENT ME!
	 */
	private Jun2dPoint _startVertex() {
		return startVertex;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param vertex
	 */
	private void _startVertex_(Jun2dPoint vertex) {
		startVertex = vertex;
	}

	/**
	 * add listeners.
	 * 
	 * @param newView sra.mvctest.StView
	 */
	protected void buildListener(StView newView) {
		final Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
	}

	/**
	 * Called when a new vertex is needed to be created.
	 * 
	 * @param event DOCUMENT ME!
	 */
	protected void creationActivity_(MouseEvent event) {
		JunOpenGLRotationModel model = (JunOpenGLRotationModel) this.model();
		JunOpenGLRotationView view = (JunOpenGLRotationView) this.view();
		Point coord = event.getPoint();
		Jun2dPoint newVertex = view.descaledPoint_(coord);
		int newIndex = model.nearestVertexIndex_(newVertex);
		model.deselectAll();
		model.addVertex_beforeIndex_(newVertex, newIndex);
		model.selectVertex_(newVertex);
		((Component) view).repaint();
		this._startIndex_(newIndex);
		this._startVertex_(newVertex);
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param event DOCUMENT ME!
	 */
	protected void selectionActivity_(MouseEvent event) {
		JunOpenGLRotationView view = (JunOpenGLRotationView) this.view();
		JunOpenGLRotationModel model = (JunOpenGLRotationModel) this.model();
		int index = this._startIndex();

		if (model.selectedIndices().contains(new Integer(index))) {
			boolean flag = model.numSelection() > 1;
			model.deselectAll();

			if (flag == true) {
				model.selectIndex_(index);
			}
		} else {
			model.deselectAll();
			model.selectIndex_(index);
		}

		((Component) view).repaint();
	}

	/**
	 * Please refer to the corresponding method in Smalltalk.
	 * 
	 * @param event DOCUMENT ME!
	 */
	protected void shiftSelectionActivity_(MouseEvent event) {
		JunOpenGLRotationView view = (JunOpenGLRotationView) this.view();
		JunOpenGLRotationModel model = (JunOpenGLRotationModel) this.model();
		int index = view.scaledVertexIndex_(new Point(event.getX(), event.getY()));

		if ((0 <= index) && (index != lastIndex)) {
			if (model.selectedIndices().contains(new Integer(index))) {
				model.deselectIndex_(index);
			} else {
				model.selectIndex_(index);
			}

			((Component) view).repaint();
		}

		lastIndex = index;
	}

}
