package jp.co.sra.jun.opengl.rotation;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOpenGLRotationApplicationViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/06/02 (by MATSUDA Ryouichi)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLRotationApplicationViewAwt.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLRotationApplicationViewAwt extends JunAbstractViewPanel implements JunOpenGLRotationApplicationView, ActionListener {

	protected JunOpenGLRotationViewAwt rotationView;
	protected TextField divisionsField;
	protected Button rotateButton;
	protected JunOpenGLDisplayViewAwt displayView;

	/**
	 * Create a new instance of JunOpenGLRotationApplicationViewAwt and initialize it.
	 *
	 * @param aModel jp.co.sra.jun.opengl.rotation.JunOpenGLRotationApplicationModel
	 */
	public JunOpenGLRotationApplicationViewAwt(JunOpenGLRotationApplicationModel aModel) {
		super(aModel);

		divisionsField.setText(String.valueOf(aModel.divisions()));
	}

	/**
	 * Actions for the event.
	 * 
	 * @param e java.awt.event.ActionEvent
	 */
	public void actionPerformed(ActionEvent e) {
		try {
			int divisions = this.divisions();
			this.getModel().divisions_(divisions);
			this.getModel().doRotate();
		} catch (NumberFormatException ex) {
			this.getModel().divisions_(this.getModel().rotationModel().lastDivisions());
		}
	}

	/**
	 * Answer insets.
	 * 
	 * @return java.awt.Insets
	 */
	public Insets getInsets() {
		return new Insets(4, 4, 4, 4);
	}

	/**
	 * model property accessing
	 * 
	 * @return jp.co.sra.jun.opengl.rotation.JunOpenGLRotationApplicationModel
	 */
	public JunOpenGLRotationApplicationModel getModel() {
		return (JunOpenGLRotationApplicationModel) this.model();
	}

	/**
	 * model property accessing
	 * 
	 * @param aModel jp.co.sra.jun.opengl.rotation.JunOpenGLRotationApplicationModel
	 */
	public void setModel(JunOpenGLRotationApplicationModel aModel) {
		this.model_(aModel);
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("divisions")) {
			this.divisions_(this.getModel().divisions());
		}
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		JunOpenGLRotationApplicationModel aModel = this.getModel();

		// Left side pane.
		rotationView = new JunOpenGLRotationViewAwt(aModel.rotationModel());
		Panel borderPanel = StApplicationModel._PanelWithBorder();
		borderPanel.setLayout(new BorderLayout());
		borderPanel.add(rotationView, BorderLayout.CENTER);

		Panel subSubPanel = new Panel();
		subSubPanel.setLayout(new FlowLayout());
		subSubPanel.add(new Label(JunSystem.$String("Divisions") + ":"));
		divisionsField = new TextField("", 5);
		subSubPanel.add(divisionsField);
		rotateButton = new Button(JunSystem.$String("Rotate"));
		rotateButton.addActionListener(this);
		subSubPanel.add(rotateButton);

		Panel subPanel = new Panel(new BorderLayout());
		subPanel.add(borderPanel, BorderLayout.CENTER);
		subPanel.add(subSubPanel, BorderLayout.SOUTH);

		// Right side pane.
		displayView = new JunOpenGLDisplayViewAwt(aModel.displayModel());

		// Layout components.
		this.setLayout(new GridLayout(1, 2));
		((GridLayout) this.getLayout()).setHgap(8);
		this.add(subPanel);
		this.add(displayView);
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new JunOpenGLRotationApplicationModel();
	}

	/**
	 * Get the number entered in the text field.
	 * 
	 * @return int
	 */
	protected int divisions() {
		return Integer.valueOf(divisionsField.getText()).intValue();
	}

	/**
	 * Set the number entered in the text field.
	 * 
	 * @param anInteger int
	 */
	protected void divisions_(int anInteger) {
		divisionsField.setText(String.valueOf(anInteger));
	}

}
