package jp.co.sra.jun.opengl.projection;

import java.awt.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.opengl.display.*;
import jp.co.sra.jun.opengl.lights.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.opengl.support.*;

/**
 * JunOpenGLProjectorTestExamples class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/04/08 (MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLProjectorTestExamples.java,v 8.10 2008/02/20 06:32:49 nisinaka Exp $
 */
public class JunOpenGLProjectorTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args DOCUMENT ME!
	 */
	public static void main(String[] args) {
		new JunOpenGLProjectorTestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean ManualExample1a() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				JunOpenGLProjector aProjector;
				JunOpenGL3dObject aGlobe;

				aRenderingContext.clear();
				aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aProjector.wireframePresentation();
				aGlobe = JunOpenGL3dObject.Globe();
				aGlobe.paint_(Color.magenta);
				aProjector.project_on_(aGlobe, aRenderingContext);
				aRenderingContext.flush();
			}
		}
		.open();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean ManualExample1b() {
		new JunOpenGLDisplayModel() {
			public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
				JunOpenGLProjector aProjector;
				JunOpenGL3dObject aGlobe;
				JunOpenGLParallelLight aParallelLight;

				aRenderingContext.clear();
				aProjector = new JunOpenGLProjector();
				aProjector.eyePoint_(new Jun3dPoint(5, 5, 5));
				aProjector.sightPoint_(new Jun3dPoint(0, 0, 0));
				aProjector.upVector_(new Jun3dPoint(0, 0, 1));
				aGlobe = JunOpenGL3dObject.Globe();
				aGlobe.paint_(Color.magenta);
				aParallelLight = JunOpenGLParallelLight.At3dPoint_color_(new Jun3dPoint(1.0, 1.0, 1.0), Color.lightGray);
				aProjector.addLight_(aParallelLight);
				aProjector.project_on_(aGlobe, aRenderingContext);
				aRenderingContext.flush();
			}
		}
		.open();

		return true;
	}
}
