package jp.co.sra.jun.opengl.picking;

import java.awt.Color;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.support.JunOpenGLInterface;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;

/**
 * JunOpenGLPickingRenderingContext class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/12 (by MATSUDA Ryouichi)
 *  @updated   2007/08/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLPickingRenderingContext.java,v 8.11 2008/02/20 06:32:48 nisinaka Exp $
 */
public class JunOpenGLPickingRenderingContext extends JunOpenGLRenderingContext {

	protected int selectionBufferSize;

	/**
	 * Create a new instance of JunOpenGLPickingRenderingContext and initialize it.
	 *
	 * @param anOpenGLObjectPicker jp.co.sra.jun.opengl.picking.JunOpenGLObjectPicker
	 * @category Instance creation
	 */
	public JunOpenGLPickingRenderingContext(JunOpenGLObjectPicker anOpenGLObjectPicker) {
		super(anOpenGLObjectPicker);
	}

	/**
	 * Create a new instance of JunOpenGLPickingRenderingContext and initialize it.
	 *
	 * @param anOpenGLObjectPicker jp.co.sra.jun.opengl.picking.JunOpenGLObjectPicker
	 * @param bufferSize int
	 * @category Instance creation
	 */
	public JunOpenGLPickingRenderingContext(JunOpenGLObjectPicker anOpenGLObjectPicker, int bufferSize) {
		super(anOpenGLObjectPicker);
		this.selectionBufferSize_(bufferSize);
	}

	/**
	 * Initialize the receiver's context.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#initializeContext()
	 * @category initialize-release
	 */
	protected void initializeContext() {
		super.initializeContext();
		super.disableBlending();
		super.disableLighting();
		super.disableFog();
		super.disablePolygonSmooth();
		super.disableLineSmooth();
		super.flatShading();
		super.disableNormalize();
		super.disableDithering();
		super.enableDepthTest();
		this.selectionBufferSize_(this.defaultSelectionBufferSize());
	}

	/**
	 * Answer my current selection buffer size.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int selectionBufferSize() {
		return selectionBufferSize;
	}

	/**
	 * Set my new selection buffer size.
	 * 
	 * @param anInteger int
	 * @category accessing
	 */
	public void selectionBufferSize_(int anInteger) {
		selectionBufferSize = anInteger;
	}

	/**
	 * Set the color id.
	 * 
	 * @param anInteger int
	 * @category accessing
	 */
	public void setId_(int anInteger) {
		this.getOpenGLInterface().glLoadName((anInteger + 1) % this.maxID());
	}

	/**
	 * Set my new color.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#setColor(java.awt.Color)
	 * @category accessing
	 */
	protected void setColor(Color aColor) {
		color = aColor;
	}

	/**
	 * Answer the default selection buffer size.
	 * 
	 * @return int
	 * @category defaults
	 */
	protected int defaultSelectionBufferSize() {
		return 1024;
	}

	/**
	 * Enable the blending.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableBlending()
	 * @category blending
	 */
	public void enableBlending() {
	}

	/**
	 * Disable the blending.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableBlending()
	 * @category blending
	 */
	public void disableBlending() {
	}

	/**
	 * Clear the color buffer.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#clearColorBuffer()
	 * @category displaying
	 */
	protected void clearColorBuffer() {
	}

	/**
	 * Display the polygon.
	 * 
	 * @param points jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#displayPolygon_(jp.co.sra.jun.geometry.basic.Jun3dPoint[])
	 * @category displaying
	 */
	public void displayPolygon_(Jun3dPoint[] points) {
		this.getOpenGLInterface().glBegin(JunOpenGLInterface.GL_POLYGON);
		for (int i = 0; i < points.length; i++) {
			this.getOpenGLInterface().glVertex3d(points[i].x(), points[i].y(), points[i].z());
		}
		this.getOpenGLInterface().glEnd();
	}

	/**
	 * Enable the dithering.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableDithering()
	 * @category dithering
	 */
	public void enableDithering() {
	}

	/**
	 * Disable the dithering.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableDithering()
	 * @category dithering
	 */
	public void disableDithering() {
	}

	/**
	 * Set the fog color.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#fogColor_(java.awt.Color)
	 * @category fogging
	 */
	public void fogColor_(Color color) {
	}

	/**
	 * Set the exp2 fog density.
	 * 
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#fogExp2Density_(float)
	 * @category fogging
	 */
	public void fogExp2Density_(float number) {
	}

	/**
	 * Set the exp fog density.
	 * 
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#fogExpDensity(float)
	 * @category fogging
	 */
	public void fogExpDensity(float number) {
	}

	/**
	 * Set the linear fog density.
	 * 
	 * @param startNumber float
	 * @param endNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#fogLinearStartDensity_endDensity_(float, float)
	 * @category fogging
	 */
	public void fogLinearStartDensity_endDensity_(float startNumber, float endNumber) {
	}

	/**
	 * Enable the fogging.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableFog()
	 * @category fogging
	 */
	public void enableFog() {
	}

	/**
	 * Disable the fogging.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableFog()
	 * @category fogging
	 */
	public void disableFog() {
	}

	/**
	 * Set the color as an ambient light.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightAmbientColor_(java.awt.Color)
	 * @category lighting
	 */
	public void lightAmbientColor_(Color color) {
	}

	/**
	 * Set the color as an ambient light.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightAmbientColor_alpha_(java.awt.Color, float)
	 * @category lighting
	 */
	public void lightAmbientColor_alpha_(Color color, float number) {
	}

	/**
	 * Set the color as an ambient light.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @param aBoolean boolean
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightAmbientColor_alpha_twoSide_(java.awt.Color, float, boolean)
	 * @category lighting
	 */
	public void lightAmbientColor_alpha_twoSide_(Color color, float number, boolean boolean1) {
	}

	/**
	 * Setup the specified light. 
	 * 
	 * @param index0to7 int
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightIndex_position_color_(int, jp.co.sra.jun.geometry.basic.Jun3dPoint, java.awt.Color)
	 * @category lighting
	 */
	public void lightIndex_position_color_(int index0to7, Jun3dPoint point, Color color) {
	}

	/**
	 * Setup the specified light. 
	 * 
	 * @param index0to7 int
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param a3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightIndex_position_direction_cutoffAngle_color_alpha_(int, jp.co.sra.jun.geometry.basic.Jun3dPoint, jp.co.sra.jun.geometry.basic.Jun3dPoint, jp.co.sra.jun.geometry.basic.JunAngle, java.awt.Color, float)
	 * @category lighting
	 */
	public void lightIndex_position_direction_cutoffAngle_color_alpha_(int index0to7, Jun3dPoint point, Jun3dPoint point2, JunAngle junAngle, Color colorValue, float number) {
	}

	/**
	 * Setup the specified light.
	 * 
	 * @param index0to7 int
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param a3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJunAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @param aNumber2 float
	 * @param aNumber3 float
	 * @param aNumber4 float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightIndex_position_direction_cutoffAngle_color_alpha_linearAttenuation_quadraticAttenuation_constantAttenuation_(int, jp.co.sra.jun.geometry.basic.Jun3dPoint, jp.co.sra.jun.geometry.basic.Jun3dPoint, jp.co.sra.jun.geometry.basic.JunAngle, java.awt.Color, float, float, float, float)
	 * @category lighting
	 */
	public void lightIndex_position_direction_cutoffAngle_color_alpha_linearAttenuation_quadraticAttenuation_constantAttenuation_(int index0to7, Jun3dPoint point, Jun3dPoint point2, JunAngle junAngle, Color colorValue, float number, float number2,
			float number3, float number4) {
	}

	/**
	 * Setup the specified light.
	 * 
	 * @param index0to7 int
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aBoolean boolean
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lightIndex_position_parallel_color_alpha_(int, jp.co.sra.jun.geometry.basic.Jun3dPoint, boolean, java.awt.Color, float)
	 * @category lighting
	 */
	public void lightIndex_position_parallel_color_alpha_(int index0to7, Jun3dPoint point, boolean boolean1, Color colorValue, float number) {
	}

	/**
	 * Enable the lighting.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableLighting()
	 * @category lighting
	 */
	public void enableLighting() {
	}

	/**
	 * Disable the lighting.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableLighting()
	 * @category lighting
	 */
	public void disableLighting() {
	}

	/**
	 * Enable the specified light.
	 * 
	 * @param index0to7 int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableLightIndex_(int)
	 * @category lighting
	 */
	public void enableLightIndex_(int index0to7) {
	}

	/**
	 * Disable the specified light.
	 * 
	 * @param index0to7 int
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableLightIndex_(int)
	 * @category lighting
	 */
	public void disableLightIndex_(int index0to7) {
	}

	/**
	 * Set the material ambient.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialAmbient_(java.awt.Color)
	 * @category material
	 */
	public void materialAmbient_(Color color) {
	}

	/**
	 * Set the material ambient.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialAmbient_alpha_(java.awt.Color, float)
	 * @category material
	 */
	public void materialAmbient_alpha_(Color color, float number) {
	}

	/**
	 * Set the material diffuse.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialDiffuse_(java.awt.Color)
	 * @category material
	 */
	public void materialDiffuse_(Color color) {
	}

	/**
	 * Set the material diffuse.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialDiffuse_alpha_(java.awt.Color, float)
	 * @category material
	 */
	public void materialDiffuse_alpha_(Color color, float number) {
	}

	/**
	 * Set the material emission.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialEmission_(java.awt.Color)
	 * @category material
	 */
	public void materialEmission_(Color color) {
	}

	/**
	 * Set the material emission.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialEmission_alpha_(java.awt.Color, float)
	 * @category material
	 */
	public void materialEmission_alpha_(Color color, float number) {
	}

	/**
	 * Set the material shininess.
	 * 
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialShininess_(float)
	 * @category material
	 */
	public void materialShininess_(float number) {
	}

	/**
	 * Set the material specular.
	 * 
	 * @param aColor java.awt.Color
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialSpecular_(java.awt.Color)
	 * @category material
	 */
	public void materialSpecular_(Color color) {
	}

	/**
	 * Set the material specular.
	 * 
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#materialSpecular_alpha_(java.awt.Color, float)
	 * @category material
	 */
	public void materialSpecular_alpha_(Color color, float number) {
	}

	/**
	 * Enable the color material.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableColorMaterial()
	 * @category material
	 */
	public void enableColorMaterial() {
	}

	/**
	 * Disable the color material.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableColorMaterial()
	 * @category material
	 */
	public void disableColorMaterial() {
	}

	/**
	 * Enable the normalize.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableNormalize()
	 * @category normalizing
	 */
	public void enableNormalize() {
	}

	/**
	 * Disable the normalize.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableNormalize()
	 * @category normalizing
	 */
	public void disableNormalize() {
	}

	/**
	 * Set my shading to flat.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#flatShading()
	 * @category shading
	 */
	public void flatShading() {
	}

	/**
	 * Set my shading to smooth.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#smoothShading()
	 * @category shading
	 */
	public void smoothShading() {
	}

	/**
	 * Set the line smooth hint to nicest.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lineSmoothNicest()
	 * @category smoothing
	 */
	public void lineSmoothNicest() {
	}

	/**
	 * Set the line smooth hint to don't care.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#lineSmoothDontCare()
	 * @category smoothing
	 */
	public void lineSmoothDontCare() {
	}

	/**
	 * Enable the line smooth.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableLineSmooth()
	 * @category smoothing
	 */
	public void enableLineSmooth() {
	}

	/**
	 * Disable the line smooth.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disableLineSmooth()
	 * @category smoothing
	 */
	public void disableLineSmooth() {
	}

	/**
	 * Set the polygon smooth hint to nicest.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#polygonSmoothNicest()
	 * @category smoothing
	 */
	public void polygonSmoothNicest() {
	}

	/**
	 * Set the polygon smooth hint to fastest.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#polygonSmoothFastest()
	 * @category smoothing
	 */
	public void polygonSmoothFastest() {
	}

	/**
	 * Set the polygon smooth hint to don't care.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#polygonSmoothDontCare()
	 * @category smoothing
	 */
	public void polygonSmoothDontCare() {
	}

	/**
	 * Enable the polygon smooth.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enablePolygonSmooth()
	 * @category smoothing
	 */
	public void enablePolygonSmooth() {
	}

	/**
	 * Disable the polygon smooth.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#disablePolygonSmooth()
	 * @category smoothing
	 */
	public void disablePolygonSmooth() {
	}

	/**
	 * Set the polygon stipple.
	 * 
	 * @param anOpenGLStipple jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#polygonStipple_(jp.co.sra.jun.opengl.texture.JunOpenGLStipple)
	 * @category stippling
	 */
	public void polygonStipple_(JunOpenGLStipple anOpenGLStipple) {
	}

	/**
	 * Enable the polygon stipple.
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enablePolygonStipple()
	 * @category stippling
	 */
	public void enablePolygonStipple() {
	}

	/**
	 * Set the new texture.
	 * 
	 * @param anOpenGLTexture jp.co.sra.jun.opengl.texture.JunOpenGLTexture
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#texture_(jp.co.sra.jun.opengl.texture.JunOpenGLTexture)
	 * @category texture mapping
	 */
	public void texture_(JunOpenGLTexture anOpenGLTexture) {
	}

	/**
	 * Enable the texture mapping. 
	 * 
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#enableTexture2d()
	 * @category texture mapping
	 */
	public void enableTexture2d() {
	}

	/**
	 * Select the nearest object while evaluating the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return int
	 * @category selecting
	 */
	public int selectNearestObjectWhile_(StBlockClosure aBlock) {
		int status = -1;
		int bufferSize = this.selectionBufferSize();
		int[] selectionBuffer = new int[bufferSize];
		int handle = -1;
		try {
			handle = this.getOpenGLInterface().glSelectBufferStart(selectionBuffer);
			this.getOpenGLInterface().glRenderMode(JunOpenGLInterface.GL_SELECT);
			this.getOpenGLInterface().glPushName(0);
			aBlock.value();
			status = this.getOpenGLInterface().glRenderMode(JunOpenGLInterface.GL_RENDER);
		} finally {
			if (handle >= 0) {
				this.getOpenGLInterface().glSelectBufferEnd(selectionBuffer, handle);
			}
		}

		int maxIndex = (status != -1) ? status : bufferSize;
		int pickedIndex = 0;
		int pickedDepth = this.maxID();
		int index = 1;
		int offset = 0;
		while (index <= maxIndex) {
			int numNames = selectionBuffer[offset];
			int minDepth = selectionBuffer[offset + 1];
			int name = selectionBuffer[offset + 3];
			if (minDepth < pickedDepth) {
				pickedIndex = name;
				pickedDepth = minDepth;
			}
			offset = offset + 3 + numNames;
			index = index + 1;
		}

		return pickedIndex - 1;
	}

	/**
	 * Answer the normal vector of the points.
	 * 
	 * @param anArrayOfPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#normalVectorOfPoints_(jp.co.sra.jun.geometry.basic.Jun3dPoint[])
	 * @category utilities
	 */
	public Jun3dPoint normalVectorOfPoints_(Jun3dPoint[] anArrayOfPoints) {
		return new Jun3dPoint(1, 1, 1);
	}

	/**
	 * Answer the normal unit vector of the points.
	 * 
	 * @param anArrayOfPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @see jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext#normalUnitVectorOfPoints_(jp.co.sra.jun.geometry.basic.Jun3dPoint[])
	 * @category utilities
	 */
	public Jun3dPoint normalUnitVectorOfPoints_(Jun3dPoint[] anArrayOfPoints) {
		return new Jun3dPoint(0.57735027955204d, 0.57735027955204d, 0.57735027955204d);
	}

	/**
	 * Answer the maximum ID.
	 * 
	 * @return int
	 * @category private
	 */
	private int maxID() {
		// OpenGLInterface GLuint baseType maxVal (4294967295L)
		return 2147483647;
	}

}
