package jp.co.sra.jun.opengl.parameterizedbody;

import java.util.*;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.*;
import jp.co.sra.jun.goodies.lisp.*;
import jp.co.sra.jun.goodies.parameter.*;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.topology.abstracts.*;
import jp.co.sra.jun.topology.elements.*;
import jp.co.sra.jun.topology.globaloperators.*;
import jp.co.sra.jun.topology.support.JunGeometryTransformer;
import jp.co.sra.smalltalk.*;

/**
 * JunParameterizedOperator class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/12/08 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterizedOperator.java,v 8.10 2008/02/20 06:32:48 nisinaka Exp $
 */
public class JunParameterizedOperator extends StModel {
	/** The parameters of the objects. */
	protected JunParameter[] parameters;

	/** The sExpression of the object. */
	protected JunLispList sExpression;

	/** The lispInterpreter of the object. */
	protected JunLispInterpreter lispInterpreter;

	/**
	 * Create a new instance of JunParameterizedOperator and set aParameter.
	 * 
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator Parameter_(JunParameter aParameter) {
		return Parameters_(new JunParameter[] { aParameter });
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * @param anSExpression java.lang.String
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator Parameter_sExpression_(JunParameter aParameter, String anSExpression) {
		return Parameters_sExpression_(new JunParameter[] { aParameter }, anSExpression);
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param aParameter jp.co.sra.jun.goodies.parameter.JunParameter
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator Parameter_sExpression_(JunParameter aParameter, JunLispList anSExpression) {
		return Parameters_sExpression_(new JunParameter[] { aParameter }, anSExpression);
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator Parameters_(JunParameter[] anArrayOfParameters) {
		JunParameterizedOperator aParameterizedOperator;

		aParameterizedOperator = new JunParameterizedOperator();
		aParameterizedOperator.parameters_(anArrayOfParameters);

		return aParameterizedOperator;
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 * @param anSExpression java.lang.String
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator Parameters_sExpression_(JunParameter[] anArrayOfParameters, String anSExpression) {
		JunParameterizedOperator aParameterizedOperator;

		aParameterizedOperator = new JunParameterizedOperator();
		aParameterizedOperator.parameters_sExpression_(anArrayOfParameters, anSExpression);

		return aParameterizedOperator;
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator Parameters_sExpression_(JunParameter[] anArrayOfParameters, JunLispList anSExpression) {
		JunParameterizedOperator aParameterizedOperator;

		aParameterizedOperator = new JunParameterizedOperator();
		aParameterizedOperator.parameters_sExpression_(anArrayOfParameters, anSExpression);

		return aParameterizedOperator;
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param anSExpression java.lang.String
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator SExpression_(String anSExpression) {
		JunParameterizedOperator aParameterizedOperator;

		aParameterizedOperator = new JunParameterizedOperator();
		aParameterizedOperator.sExpression_(anSExpression);

		return aParameterizedOperator;
	}

	/**
	 * Create a new instance of JunParameterizedOperator and set parameters.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public static JunParameterizedOperator SExpression_(JunLispList anSExpression) {
		JunParameterizedOperator aParameterizedOperator;

		aParameterizedOperator = new JunParameterizedOperator();
		aParameterizedOperator.sExpression_(anSExpression);

		return aParameterizedOperator;
	}

	/**
	 * Smalltalk like copyFrom:to: method.
	 * 
	 * @param arguments double[]
	 * @param from int
	 * @param to int
	 * 
	 * @return double[]
	 */
	private static double[] _Copy_from_to_(double[] arguments, int from, int to) {
		double[] array;

		array = new double[to - from + 1];

		for (int i = 0; i < (to - from + 1); i++) {
			array[i] = arguments[from + i];
		}

		return array;
	}

	/**
	 * Apply operators to aBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public void applyOperatorsTo_(JunBody aBody) {
		if (this.sExpression() == JunLispNil.NullList()) {
			return;
		}

		this.beginInterpretation();

		try {
			this.applyOperators_to_(this.sExpression(), aBody);
		} finally {
			this.endInterpretation();
		}
	}

	/**
	 * Apply transformations to aJunOpenGL3dObject.
	 * 
	 * @param aJunOpenGL3dObject
	 *        jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 */
	public JunOpenGL3dObject applyTransformationsTo_(JunOpenGL3dObject aJunOpenGL3dObject) {
		if (this.sExpression() == JunLispNil.NullList()) {
			return aJunOpenGL3dObject;
		}

		this.beginInterpretation();

		try {
			return this.applyTransformations_to_(this.sExpression(), aJunOpenGL3dObject);
		} finally {
			this.endInterpretation();
		}
	}

	/**
	 * Answer the parameters.
	 * 
	 * @return jp.co.sra.jun.goodies.parameterJunParameter[]
	 */
	public JunParameter[] parameters() {
		if (parameters == null) {
			this.setParameters_(new JunParameter[] {});
		}

		return parameters;
	}

	/**
	 * Set the parameters.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 */
	public void parameters_(JunParameter[] anArrayOfParameters) {
		this.setParameters_(anArrayOfParameters);
		this.changed_($("parameters"));
	}

	/**
	 * Set the parameters, sExpression.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 * @param anSExpression java.lang.String
	 */
	public void parameters_sExpression_(JunParameter[] anArrayOfParameters, String anSExpression) {
		this.setParameters_(anArrayOfParameters);
		this.setSExpression_(anSExpression);
		this.changed_($("parameters"));
	}

	/**
	 * Set the parameters, sExpression.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	public void parameters_sExpression_(JunParameter[] anArrayOfParameters, JunLispList anSExpression) {
		this.setParameters_(anArrayOfParameters);
		this.setSExpression_(anSExpression);
		this.changed_($("parameters"));
	}

	/**
	 * Answer the sExpression.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	public JunLispList sExpression() {
		if (sExpression == null) {
			sExpression = JunLispNil.NullList();
		}

		return sExpression;
	}

	/**
	 * Set the sExpression.
	 * 
	 * @param anSExpression java.lang.String
	 */
	public void sExpression_(String anSExpression) {
		this.setSExpression_(anSExpression);
		this.changed_($("sExpression"));
	}

	/**
	 * Set the sExpression.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	public void sExpression_(JunLispList anSExpression) {
		this.setSExpression_(anSExpression);
		this.changed_($("sExpression"));
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (evt.getAspect() == $("value")) {
			this.changed_($("value"));
		}
	}

	/**
	 * Apply operators anSExpression to aBody.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	protected void applyOperators_to_(JunLispList anSExpression, final JunBody aBody) {
		final JunParameterizedOperator this_ = this;
		JunAbstractOperator operator;

		if (((JunLispCons) anSExpression).head() == $("COMPOUND")) {
			((JunLispList) ((JunLispCons) anSExpression).tail()).do_(new StBlockClosure() {
				public Object value_(Object o) {
					JunLispList each = (JunLispList) o;
					this_.applyOperators_to_(each, aBody);

					return null;
				}
			});
		} else {
			operator = this.instanciateOperator_(anSExpression);
			operator.body_(aBody);
			operator.doOperation();
		}
	}

	/**
	 * Apply transformations anSExpression to aJunOpenGL3dObject.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param aJunOpenGL3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	protected JunOpenGL3dObject applyTransformations_to_(JunLispList anSExpression, JunOpenGL3dObject aJunOpenGL3dObject) {
		final JunParameterizedOperator this_ = this;
		final StValueHolder transformedObject_ = new StValueHolder(); // JunOpenGL3dObject
		Jun3dTransformation transformation;

		if (((JunLispCons) anSExpression).head() == $("COMPOUND")) {
			transformedObject_.value_(aJunOpenGL3dObject);
			((JunLispList) ((JunLispCons) anSExpression).tail()).do_(new StBlockClosure() {
				public Object value_(Object o) {
					JunLispList each = (JunLispList) o;
					transformedObject_.value_(this_.applyTransformations_to_(each, (JunOpenGL3dObject) transformedObject_.value()));

					return null;
				}
			});
		} else {
			transformation = this.instanciateTransformation_(anSExpression);
			transformedObject_.value_(aJunOpenGL3dObject.transform_(transformation));
		}

		return (JunOpenGL3dObject) transformedObject_.value();
	}

	/**
	 * Begin interpretation.
	 */
	protected void beginInterpretation() {
		final JunParameterizedOperator this_ = this;

		if (lispInterpreter == null) {
			lispInterpreter = new JunLispInterpreter();
			lispInterpreter.evaluateTopLevel_ifFail_(JunLispNil.NullList(), new StBlockClosure() {
				public Object value_(Object value) {
					String errorMessage = (String) value;
					this_.error_(errorMessage);

					return null;
				}
			});
		}

		lispInterpreter.bindMark();

		for (int i = 0; i < this.parameters().length; i++) {
			JunParameter each = this.parameters()[i];
			lispInterpreter.bind_value_($(each.name()), new Double(each.value()));
		}
	}

	/**
	 * End interpretation.
	 */
	protected void endInterpretation() {
		lispInterpreter.unbind();
	}

	/**
	 * Evaluate arguments anSExpression count aNumber.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * @param aNumber int
	 * 
	 * @return double[]
	 */
	protected double[] evaluateArguments_count_(JunLispList anSExpression, int aNumber) {
		final Vector arguments = new Vector();

		if (((JunLispCons) ((JunLispCons) anSExpression).tail()).length() != aNumber) {
			//return lispInterpreter.fatal_("too few or many arguments for " + ((JunLispCons) anSExpression).head());
			return null;
		}

		((JunLispList) ((JunLispCons) anSExpression).tail()).do_(new StBlockClosure() {
			public Object value_(Object each) {
				arguments.addElement(lispInterpreter.evaluate_(each));

				return null;
			}
		});

		double[] _arguments = new double[arguments.size()];

		for (int i = 0; i < arguments.size(); i++) {
			_arguments[i] = ((Number) arguments.elementAt(i)).doubleValue();
		}

		return _arguments;
	}

	/**
	 * Instanciate operator anSExpression.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunGlobalOperator
	 */
	protected JunGlobalOperator instanciateOperator_(JunLispList anSExpression) {
		double[] arguments;
		Jun3dPoint point;
		Jun3dPoint vector;
		JunAngle angle;
		double factor;

		if (anSExpression.head() == $("MOVE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 3);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));

			return JunMOVE.Body_vector_(null, point);
		}

		if (anSExpression.head() == $("ROTATE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			angle = JunAngle.FromRad_(_Copy_from_to_(arguments, 6, 6)[0]);

			return JunROTATE.Body_point_vector_angle_(null, point, vector, angle);
		}

		if (anSExpression.head() == $("ROTATEDeg")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			angle = JunAngle.FromDeg_(_Copy_from_to_(arguments, 6, 6)[0]);

			return JunROTATE.Body_point_vector_angle_(null, point, vector, angle);
		}

		if (anSExpression.head() == $("PointSCALE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 4);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			factor = _Copy_from_to_(arguments, 3, 3)[0];

			return JunPointSCALE.Body_point_factor_(null, point, factor);
		}

		if (anSExpression.head() == $("LineSCALE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			factor = _Copy_from_to_(arguments, 6, 6)[0];

			return JunLineSCALE.Body_point_vector_factor_(null, point, vector, factor);
		}

		if (anSExpression.head() == $("PlaneSCALE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			factor = _Copy_from_to_(arguments, 6, 6)[0];

			return JunPlaneSCALE.Body_point_vector_factor_(null, point, vector, factor);
		}

		//return this.invalidOperatorError_(anSExpression);
		return null;
	}

	/**
	 * Instanciate transformation anSExpression.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 */
	protected Jun3dTransformation instanciateTransformation_(JunLispList anSExpression) {
		double[] arguments;
		Jun3dPoint point;
		Jun3dPoint vector;
		// Jun3dLine scaleAxis;
		JunAngle angle;
		// double factor;

		if (anSExpression.head() == $("MOVE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 3);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));

			return Jun3dTransformation.Translate_(point);
		}

		if (anSExpression.head() == $("ROTATE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			angle = JunAngle.FromRad_(_Copy_from_to_(arguments, 6, 6)[0]);

			return Jun3dTransformation.Rotate_around_(angle, new Jun3dLine(point, (Jun3dPoint) point.plus_(vector)));
		}

		if (anSExpression.head() == $("ROTATEDeg")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			angle = JunAngle.FromDeg_(_Copy_from_to_(arguments, 6, 6)[0]);

			return Jun3dTransformation.Rotate_around_(angle, new Jun3dLine(point, (Jun3dPoint) point.plus_(vector)));
		}

		if (anSExpression.head() == $("PointSCALE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 4);

			final Jun3dPoint point_ = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			final double factor_ = _Copy_from_to_(arguments, 3, 3)[0];

			return JunGeometryTransformer.Block_(new StBlockClosure() {
				public Object value_(Object value) {
					Jun3dPoint p = (Jun3dPoint) value;
					Jun3dPoint relativePosition;
					relativePosition = (Jun3dPoint) p.minus_(point_);

					return relativePosition.multipliedBy_(factor_).plus_(point_);
				}
			});
		}

		if (anSExpression.head() == $("LineSCALE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);
			point = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			vector = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));

			final Jun3dLine scaleAxis_ = new Jun3dLine(point, (Jun3dPoint) point.plus_(vector.unitVector()));
			final double factor_ = _Copy_from_to_(arguments, 6, 6)[0];

			return JunGeometryTransformer.Block_(new StBlockClosure() {
				public Object value_(Object value) {
					Jun3dPoint p = (Jun3dPoint) value;
					Jun3dPoint referencePoint;
					Jun3dPoint relativePosition;
					referencePoint = scaleAxis_.nearestPointFromPoint_(p);
					relativePosition = (Jun3dPoint) p.minus_(referencePoint);

					return relativePosition.multipliedBy_(factor_).plus_(referencePoint);
				}
			});
		}

		if (anSExpression.head() == $("PlaneSCALE")) {
			arguments = this.evaluateArguments_count_(anSExpression, 7);

			final Jun3dPoint point_ = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 0, 2));
			final Jun3dPoint vector_ = Jun3dPoint.FromArray_(_Copy_from_to_(arguments, 3, 5));
			final Jun3dLine scaleAxis_ = new Jun3dLine(point_, (Jun3dPoint) point_.plus_(vector_.unitVector()));
			final double factor_ = _Copy_from_to_(arguments, 6, 6)[0];

			return JunGeometryTransformer.Block_(new StBlockClosure() {
				public Object value_(Object value) {
					Jun3dPoint p = (Jun3dPoint) value;
					Jun3dPoint pVector;
					Jun3dPoint qVector;
					Jun3dPoint rVector;
					JunAngle anAngle;
					double pDistance;
					double qLength;
					pVector = (Jun3dPoint) p.minus_(point_);
					pDistance = pVector.length();

					if (pDistance < pVector.Accuracy()) {
						return p;
					} else {
						anAngle = scaleAxis_.angleWithLine_(new Jun3dLine(point_, p));
						qLength = anAngle.cos() * pDistance;
						qVector = (Jun3dPoint) vector_.unitVector().multipliedBy_(qLength);

						if (qVector.innerProduct_(pVector) < 0) {
							qVector = (Jun3dPoint) qVector.negated();
						}

						rVector = (Jun3dPoint) pVector.minus_(qVector);

						return qVector.multipliedBy_(factor_).plus_(rVector).plus_(point_);
					}
				}
			});
		}

		//return this.invalidOperatorError_(anSExpression);
		return null;
	}

	/**
	 * Invalid operator error anSExpression.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 * 
	 * @return java.lang.String
	 */
	protected String invalidOperatorError_(JunLispList anSExpression) {
		return lispInterpreter.fatal_("invalid operator: ") + anSExpression.head().toString();
	}

	/**
	 * Set the parameters.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameterJunParameter[]
	 */
	protected void setParameters_(JunParameter[] anArrayOfParameters) {
		if (parameters != null) {
			for (int i = 0; i < parameters.length; i++) {
				JunParameter each = parameters[i];
				each.removeDependent_(this);
			}
		}

		parameters = anArrayOfParameters;

		if (parameters != null) {
			for (int i = 0; i < parameters.length; i++) {
				JunParameter each = parameters[i];
				each.addDependent_(this);
			}
		}
	}

	/**
	 * Set the sExpression.
	 * 
	 * @param anSExpression java.lang.String
	 */
	protected void setSExpression_(String anSExpression) {
		sExpression = (JunLispList) JunLispParser.Parse_(anSExpression);
	}

	/**
	 * Set the sExpression.
	 * 
	 * @param anSExpression jp.co.sra.jun.goodies.lisp.JunLispList
	 */
	protected final void setSExpression_(JunLispList anSExpression) {
		sExpression = anSExpression;
	}
}
