package jp.co.sra.jun.opengl.parameterizedbody;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.jun.goodies.parameter.JunParametersViewAwt;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunParameterizedBodyViewAwt class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/19 (by MATSUDA Ryouichi)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun471 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterizedBodyViewAwt.java,v 8.10 2008/02/20 06:32:48 nisinaka Exp $
 */
public class JunParameterizedBodyViewAwt extends JunAbstractViewPanel implements JunParameterizedBodyView {

	protected JunOpenGLDisplayViewAwt displayView;
	protected JunParametersViewAwt parametersView;
	protected Checkbox interlockCheckbox;
	protected Button createBodyButton;

	/**
	 * Create a new instance of JunParameterizedBodyViewAwt and initialize it.
	 *
	 * @param aModel jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModel
	 */
	public JunParameterizedBodyViewAwt(JunParameterizedBodyModel aModel) {
		super(aModel);
	}

	/**
	 * Answer insets.
	 * 
	 * @return java.awt.Insets
	 */
	public Insets getInsets() {
		return new Insets(4, 4, 4, 4);
	}

	/**
	 * model property accessing
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModel
	 */
	public JunParameterizedBodyModel getModel() {
		return (JunParameterizedBodyModel) this.model();
	}

	/**
	 * model property accessing
	 * 
	 * @param aModel jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBodyModel
	 */
	public void setModel(JunParameterizedBodyModel aModel) {
		this.model_(aModel);
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		JunParameterizedBodyModel theModel = this.getModel();

		Label label = new Label(JunSystem.$String("Parameter", "Parameters") + " :");
		label.setFont(new Font("dialog", Font.BOLD, 12));

		Checkbox interlockCheckbox = new Checkbox(JunSystem.$String("Interlock"), null, true);
		interlockCheckbox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					getModel().interlockHolder().value_(Boolean.TRUE);
				}
				if (e.getStateChange() == ItemEvent.DESELECTED) {
					getModel().interlockHolder().value_(Boolean.FALSE);
				}
			}
		});

		Panel northPanel = new Panel();
		northPanel.setLayout(new BorderLayout());
		northPanel.add(label, BorderLayout.WEST);
		northPanel.add(interlockCheckbox, BorderLayout.EAST);

		parametersView = new JunParametersViewAwt(theModel.parametersModel());

		Button createBodyButton = new Button(JunSystem.$String("Create Body"));
		createBodyButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				getModel().createBody();
			}
		});

		Panel centerPanel = new Panel();
		centerPanel.setLayout(new BorderLayout());
		centerPanel.add(northPanel, BorderLayout.NORTH);
		centerPanel.add(parametersView, BorderLayout.CENTER);
		centerPanel.add(createBodyButton, BorderLayout.SOUTH);

		//
		displayView = new JunOpenGLDisplayViewAwt(theModel.displayModel());

		// Layout components.
		this.setLayout(new GridLayout(1, 2));
		((GridLayout) this.getLayout()).setHgap(8);
		this.add(displayView);
		this.add(centerPanel);
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 */
	protected StModel defaultModel() {
		return new JunParameterizedBodyModel();
	}

}
