package jp.co.sra.jun.opengl.parameterizedbody;

import java.util.Vector;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.jun.goodies.parameter.JunParameter;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.setoperators.JunUNION;

/**
 * JunParameterizedBody class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/12/08 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterizedBody.java,v 8.10 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunParameterizedBody extends StModel implements JunParameterizedOrPaintedBody {
	/** The name of the object. */
	protected String name;

	/** The components of the objects. */
	protected JunParameterizedOrPaintedBody[] components;

	/** The parameterizedOperator of the object. */
	protected JunParameterizedOperator parameterizedOperator;

	/** The cachedBody of the object. */
	protected JunBody cachedBody;

	/** The cached3dObject of the object. */
	protected JunOpenGL3dObject cached3dObject;

	/** The _allParameters of the objects. */
	protected JunParameter[] _allParameters;

	/**
	 * Create a new instance of JunParameterizedBody and set components.
	 * 
	 * @param anArrayOfComponents
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody[]
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Components_(JunParameterizedOrPaintedBody[] anArrayOfComponents) {
		JunParameterizedBody aParameterizedBody;

		aParameterizedBody = new JunParameterizedBody();
		aParameterizedBody.components_(anArrayOfComponents);

		return aParameterizedBody;
	}

	/**
	 * Answer a class of default ApplicationModel.
	 * 
	 * @return java.lang.Class
	 */
	public static Class DefaultApplicationModelClass() {
		return JunParameterizedBodyModel.class;
	}

	/**
	 * Answer a class of default ParameterizedOperator.
	 * 
	 * @return java.lang.Class
	 */
	public static Class DefaultParameterizedOperatorClass() {
		return JunParameterizedOperator.class;
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param anArrayOfComponents
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody[]
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_components_(String aString, JunParameterizedOrPaintedBody[] anArrayOfComponents) {
		JunParameterizedBody aParameterizedBody;

		aParameterizedBody = Components_(anArrayOfComponents);
		aParameterizedBody.name_(aString);

		return aParameterizedBody;
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param anArrayOfComponents
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody[]
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_parameterizedOperator_components_(String aString, JunParameterizedOperator aParameterizedOperator, JunParameterizedOrPaintedBody[] anArrayOfComponents) {
		JunParameterizedBody aParameterizedBody;

		aParameterizedBody = ParameterizedOperator_components_(aParameterizedOperator, anArrayOfComponents);
		aParameterizedBody.name_(aString);

		return aParameterizedBody;
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param aComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_parameterizedOperator_with_(String aString, JunParameterizedOperator aParameterizedOperator, JunParameterizedOrPaintedBody aComponent) {
		return Name_parameterizedOperator_components_(aString, aParameterizedOperator, new JunParameterizedOrPaintedBody[] { aComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_parameterizedOperator_with_with_(String aString, JunParameterizedOperator aParameterizedOperator, JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent) {
		return Name_parameterizedOperator_components_(aString, aParameterizedOperator, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_parameterizedOperator_with_with_with_(
		String aString,
		JunParameterizedOperator aParameterizedOperator,
		JunParameterizedOrPaintedBody firstComponent,
		JunParameterizedOrPaintedBody secondComponent,
		JunParameterizedOrPaintedBody thirdComponent) {
		return Name_parameterizedOperator_components_(aString, aParameterizedOperator, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param fourthComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_parameterizedOperator_with_with_with_with_(
		String aString,
		JunParameterizedOperator aParameterizedOperator,
		JunParameterizedOrPaintedBody firstComponent,
		JunParameterizedOrPaintedBody secondComponent,
		JunParameterizedOrPaintedBody thirdComponent,
		JunParameterizedOrPaintedBody fourthComponent) {
		return Name_parameterizedOperator_components_(aString, aParameterizedOperator, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent, fourthComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_with_(String aString, JunParameterizedOrPaintedBody aComponent) {
		return Name_components_(aString, new JunParameterizedOrPaintedBody[] { aComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_with_with_(String aString, JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent) {
		return Name_components_(aString, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_with_with_with_(String aString, JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent, JunParameterizedOrPaintedBody thirdComponent) {
		return Name_components_(aString, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param fourthComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody Name_with_with_with_with_(
		String aString,
		JunParameterizedOrPaintedBody firstComponent,
		JunParameterizedOrPaintedBody secondComponent,
		JunParameterizedOrPaintedBody thirdComponent,
		JunParameterizedOrPaintedBody fourthComponent) {
		return Name_components_(aString, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent, fourthComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param anArrayOfComponents
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody[]
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody ParameterizedOperator_components_(JunParameterizedOperator aParameterizedOperator, JunParameterizedOrPaintedBody[] anArrayOfComponents) {
		JunParameterizedBody aParameterizedBody;

		aParameterizedBody = Components_(anArrayOfComponents);
		aParameterizedBody.parameterizedOperator_(aParameterizedOperator);

		return aParameterizedBody;
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param aComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody ParameterizedOperator_with_(JunParameterizedOperator aParameterizedOperator, JunParameterizedOrPaintedBody aComponent) {
		return ParameterizedOperator_components_(aParameterizedOperator, new JunParameterizedOrPaintedBody[] { aComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody ParameterizedOperator_with_with_(JunParameterizedOperator aParameterizedOperator, JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent) {
		return ParameterizedOperator_components_(aParameterizedOperator, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody ParameterizedOperator_with_with_with_(
		JunParameterizedOperator aParameterizedOperator,
		JunParameterizedOrPaintedBody firstComponent,
		JunParameterizedOrPaintedBody secondComponent,
		JunParameterizedOrPaintedBody thirdComponent) {
		return ParameterizedOperator_components_(aParameterizedOperator, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param fourthComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody ParameterizedOperator_with_with_with_with_(
		JunParameterizedOperator aParameterizedOperator,
		JunParameterizedOrPaintedBody firstComponent,
		JunParameterizedOrPaintedBody secondComponent,
		JunParameterizedOrPaintedBody thirdComponent,
		JunParameterizedOrPaintedBody fourthComponent) {
		return ParameterizedOperator_components_(aParameterizedOperator, new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent, fourthComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param aComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody With_(JunParameterizedOrPaintedBody aComponent) {
		return Components_(new JunParameterizedOrPaintedBody[] { aComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody With_with_(JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent) {
		return Components_(new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody With_with_with_(JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent, JunParameterizedOrPaintedBody thirdComponent) {
		return Components_(new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent });
	}

	/**
	 * Create a new instance of JunParameterizedBody and set parameters.
	 * 
	 * @param firstComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param secondComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param thirdComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * @param fourthComponent
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 */
	public static JunParameterizedBody With_with_with_with_(JunParameterizedOrPaintedBody firstComponent, JunParameterizedOrPaintedBody secondComponent, JunParameterizedOrPaintedBody thirdComponent, JunParameterizedOrPaintedBody fourthComponent) {
		return Components_(new JunParameterizedOrPaintedBody[] { firstComponent, secondComponent, thirdComponent, fourthComponent });
	}

	/**
	 * Answer all parameters.
	 * 
	 * @return jp.co.sra.jun.goodies.parameterJunParameter[]
	 */
	public JunParameter[] allParameters() {
		Vector parameters;

		if (_allParameters == null) {
			parameters = new Vector();

			for (int i = 0; i < this.parameterizedOperator().parameters().length; i++) {
				parameters.addElement(this.parameterizedOperator().parameters()[i]);
			}

			for (int i = 0; i < this.components().length; i++) {
				if (this.components()[i] instanceof JunParameterizedBody) {
					JunParameterizedBody each = (JunParameterizedBody) this.components()[i];

					for (int j = 0; j < each.allParameters().length; j++) {
						JunParameter parameter = (JunParameter) each.allParameters()[j];

						if (parameters.contains(parameter) == false) {
							parameters.addElement(parameter);
						}
					}
				}
			}

			_allParameters = new JunParameter[parameters.size()];
			parameters.copyInto(_allParameters);
		}

		return _allParameters;
	}

	/**
	 * Convert recevier to JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		if (cached3dObject == null) {
			cached3dObject = new JunOpenGL3dCompoundObject();

			for (int i = 0; i < this.components().length; i++) {
				JunParameterizedOrPaintedBody each = this.components()[i];
				((JunOpenGL3dCompoundObject) cached3dObject).add_(each.asJunOpenGL3dObject());
			}

			cached3dObject = this.parameterizedOperator().applyTransformationsTo_(cached3dObject);
		}

		return cached3dObject;
	}

	/**
	 * Answer a body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunBody body() {
		if (cachedBody == null) {
			cachedBody = (JunBody) this.bodyAt_(0).copy();

			for (int each = 1; each < this.components().length; each++) {
				new JunUNION(cachedBody, (JunBody) this.bodyAt_(each).copy()).doOperation();
			}

			this.parameterizedOperator().applyOperatorsTo_(cachedBody);
		}

		return cachedBody;
	}

	/**
	 * Answer a body at index.
	 * 
	 * @param anIndex int
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunBody bodyAt_(int anIndex) {
		return this.components()[anIndex].body();
	}

	/**
	 * Answer the components.
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody[]
	 */
	public JunParameterizedOrPaintedBody[] components() {
		if (components == null) {
			components = new JunParameterizedOrPaintedBody[] {
			};
		}

		return components;
	}

	/**
	 * Set the components.
	 * 
	 * @param anArrayOfComponents
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOrPaintedBody[]
	 */
	public void components_(JunParameterizedOrPaintedBody[] anArrayOfComponents) {
		if (components != null) {
			for (int i = 0; i < components.length; i++) {
				StObject each = (StObject) components[i];
				each.removeDependent_(this);
			}
		}

		components = anArrayOfComponents;

		if (components != null) {
			for (int i = 0; i < components.length; i++) {
				StObject each = (StObject) components[i];
				each.addDependent_(this);
			}
		}

		this.flushCache();
	}

	/**
	 * Flush the cachedBody, cached3dObject.
	 */
	public void flushCache() {
		cachedBody = null;
		cached3dObject = null;
		this.changed();
	}

	/**
	 * Answer the name.
	 * 
	 * @return java.lang.String
	 */
	public final String name() {
		return name;
	}

	/**
	 * Set the name.
	 * 
	 * @param aString java.lang.String
	 */
	public final void name_(String aString) {
		name = aString;
	}

	/**
	 * Answer a named parameter.
	 * 
	 * @param aString java.lang.String
	 * 
	 * @return jp.co.sra.jun.goodies.JunParameter
	 */
	public JunParameter namedParameter_(String aString) {
		for (int i = 0; i < this.allParameters().length; i++) {
			JunParameter each = this.allParameters()[i];

			if (each.name().equals(aString)) {
				return each;
			}
		}

		return null;
	}

	/**
	 * Set value to named parameter.
	 * 
	 * @param aString java.lang.String
	 * @param aValue double
	 */
	public void namedParameter_value_(String aString, double aValue) {
		JunParameter aParameter;

		aParameter = this.namedParameter_(aString);

		if (aParameter != null) {
			aParameter.value_(aValue);
		}
	}

	/**
	 * Answer the parameterizedOperator.
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public JunParameterizedOperator parameterizedOperator() {
		if (parameterizedOperator == null) {
			parameterizedOperator = new JunParameterizedOperator();
		}

		return parameterizedOperator;
	}

	/**
	 * Set the parameterizedOperator.
	 * 
	 * @param aParameterizedOperator
	 *        jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedOperator
	 */
	public void parameterizedOperator_(JunParameterizedOperator aParameterizedOperator) {
		if (parameterizedOperator != null) {
			parameterizedOperator.removeDependent_(this);
		}

		parameterizedOperator = aParameterizedOperator;

		if (parameterizedOperator != null) {
			parameterizedOperator.addDependent_(this);
		}

		this.flushCache();
	}

	/**
	 * Display receiver.
	 */
	public void show() {
		JunParameterizedBodyModel.OpenOnParameterizedBody_(this);
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		this.flushCache();
	}
}
