package jp.co.sra.jun.opengl.objects.typical;

import java.awt.Color;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;

/**
 * JunOpenGL3dTypicalObjectsPlate class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsPlate.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsPlate extends JunOpenGL3dTypicalObjectsImage {
	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateBMWC() {
		Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(0, 0, 1), new Jun3dPoint(1, 0, 1), new Jun3dPoint(1, 1, 1), new Jun3dPoint(0, 1, 1) };
		return PlateVertexes_textureImage_(points, ImageBMWC());
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateGCWY() {
		Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(0, 1, 0), new Jun3dPoint(0, 1, 1), new Jun3dPoint(1, 1, 1), new Jun3dPoint(1, 1, 0) };
		return PlateVertexes_textureImage_(points, ImageGCWY());
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateKBCG() {
		Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1), new Jun3dPoint(0, 1, 1), new Jun3dPoint(0, 1, 0) };
		return PlateVertexes_textureImage_(points, ImageKBCG());
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateKGYR() {
		Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(1, 0, 0) };
		return PlateVertexes_textureImage_(points, ImageKGYR());
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateKRMB() {
		Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), new Jun3dPoint(1, 0, 1), new Jun3dPoint(0, 0, 1) };
		return PlateVertexes_textureImage_(points, ImageKRMB());
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateRYWM() {
		Jun3dPoint[] points = new Jun3dPoint[] { new Jun3dPoint(1, 0, 0), new Jun3dPoint(1, 1, 0), new Jun3dPoint(1, 1, 1), new Jun3dPoint(1, 0, 1) };
		return PlateVertexes_textureImage_(points, ImageRYWM());
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	protected static JunOpenGL3dObject PlateVertexes_textureImage_(Jun3dPoint[] vertexCollection, StImage anImage) {
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(false);
		aTexture.repeat_(false);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0.0, 1.0), new Jun2dPoint(0.0, 0.0), new Jun2dPoint(1.0, 0.0), new Jun2dPoint(1.0, 1.0) });
		JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(vertexCollection);
		aPolygon.paint_(Color.white);
		aPolygon.texture_(aTexture);
		return aPolygon;
	}
}
