package jp.co.sra.jun.opengl.objects.typical;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunOpenGL3dTypicalObjectsMobius class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsMobius.java,v 8.6 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsMobius extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical object - mobius
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject Mobius() {
		return MobiusRadius_divisions_stripRadius_divisions_(3.0 / 4.0, 72, 1.0 / 4.0, 6);
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_(double mobiusRadius, int mobiusDivision, double stripRadius) {
		if (mobiusRadius > stripRadius == false) {
			throw new IllegalArgumentException("can not create mobius.");
		}

		double stepDegrees = 1.0d / mobiusDivision;
		ArrayList thetaCollection = new ArrayList();
		for (double theta = 0.0d; theta <= 2.0d - (stepDegrees / 2.0d); theta += stepDegrees) {
			thetaCollection.add(new Double(theta));
		}
		thetaCollection.add(new Double(2.0));
		Double[] thetaArray = (Double[]) thetaCollection.toArray(new Double[thetaCollection.size()]);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < thetaArray.length - 1; i++) {
			double firstTheta = thetaArray[i].doubleValue();
			double secondTheta = thetaArray[i + 1].doubleValue();
			Jun3dPoint firstPoint = JunGeometry.MobiusRadius_normalizedTheta_stripRadius_normalizedRadius_(mobiusRadius, firstTheta, stripRadius, 1);
			Jun3dPoint secondPoint = JunGeometry.MobiusRadius_normalizedTheta_stripRadius_normalizedRadius_(mobiusRadius, secondTheta, stripRadius, 1);
			JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[] { firstPoint, secondPoint });
			compoundObject.add_(aPolyline);
		}
		compoundObject.name_("mobius polyline");
		compoundObject.flushAllPaints();
		compoundObject.paint_(DefaultPaint());
		return compoundObject;
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param stripDivision int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_divisions_(double mobiusRadius, int mobiusDivision, double stripRadius, int stripDivision) {
		if (mobiusRadius > stripRadius == false) {
			throw new IllegalArgumentException("can not create mobius.");
		}

		double stepDegrees = 1.0d / mobiusDivision;
		ArrayList thetaCollection = new ArrayList();
		for (double theta = 0.0d; theta <= 2.0d - (stepDegrees / 2.0d); theta += stepDegrees) {
			thetaCollection.add(new Double(theta));
		}
		thetaCollection.add(new Double(2.0));
		Double[] thetaArray = (Double[]) thetaCollection.toArray(new Double[thetaCollection.size()]);

		stepDegrees = 1.0d / stripDivision;
		ArrayList radiusCollection = new ArrayList();
		for (double radius = 0.0d; radius <= 1.0d - (stepDegrees / 2.0d); radius += stepDegrees) {
			radiusCollection.add(new Double(radius));
		}
		radiusCollection.add(new Double(1.0));
		Double[] radiusArray = (Double[]) radiusCollection.toArray(new Double[radiusCollection.size()]);
		Double[] reverseArray = new Double[radiusArray.length];
		for (int i = 0; i < radiusArray.length; i++) {
			reverseArray[reverseArray.length - 1 - i] = radiusArray[i];
		}
		radiusArray = reverseArray;

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < thetaArray.length - 1; i++) {
			double firstTheta = thetaArray[i].doubleValue();
			double secondTheta = thetaArray[(i == thetaArray.length - 2) ? 0 : i + 1].doubleValue();
			Jun3dPoint[] firstPoints = new Jun3dPoint[radiusArray.length];
			Jun3dPoint[] secondPoints = new Jun3dPoint[radiusArray.length];

			for (int j = 0; j < radiusArray.length; j++) {
				double aRadius = radiusArray[j].doubleValue();
				Jun3dPoint mobiusPoint = JunGeometry.MobiusRadius_normalizedTheta_stripRadius_normalizedRadius_(mobiusRadius, firstTheta, stripRadius, aRadius);
				firstPoints[j] = mobiusPoint;
				mobiusPoint = JunGeometry.MobiusRadius_normalizedTheta_stripRadius_normalizedRadius_(mobiusRadius, secondTheta, stripRadius, aRadius);
				secondPoints[j] = mobiusPoint;
			}
			JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
			for (int j = 0; j < firstPoints.length - 1; j++) {
				int firstIndex = j;
				int secondIndex = j + 1;
				Jun3dPoint firstPoint = firstPoints[firstIndex];
				Jun3dPoint secondPoint = secondPoints[firstIndex];
				Jun3dPoint thirdPoint = firstPoints[secondIndex];
				Jun3dPoint forthPoint = secondPoints[secondIndex];
				JunOpenGL3dPolygon firstPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { firstPoint, secondPoint, thirdPoint });
				JunOpenGL3dPolygon secondPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { secondPoint, forthPoint, thirdPoint });
				aBody.add_(firstPolygon);
				aBody.add_(secondPolygon);
			}
			compoundObject.add_(aBody);
		}
		compoundObject.name_("mobius");
		compoundObject.flushAllPaints();
		compoundObject.paint_(DefaultPaint());
		return compoundObject;
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_locusDo_(double mobiusRadius, int mobiusDivision, double stripRadius, StBlockClosure aBlock) {
		JunOpenGL3dCompoundObject mobiusBody = (JunOpenGL3dCompoundObject) MobiusRadius_divisions_stripRadius_divisions_(mobiusRadius, mobiusDivision, stripRadius, 1);
		JunOpenGL3dObject[] components = mobiusBody.components();
		for (int i = 0; i < components.length; i++) {
			JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) ((JunOpenGL3dCompoundObject) components[i]).components()[0];
			Jun3dPoint locusPoint = aPolygon.vertexes()[2];
			Jun3dPoint rightVector = locusPoint.to_(aPolygon.vertexes()[0]).normalUnitVector();
			Jun3dPoint upVector = aPolygon.normalUnitVector();
			double normalizedValue = i / (double) mobiusBody.components().length;
			Object[] anArray = new Object[] { locusPoint, rightVector, upVector, new Double(normalizedValue) };
			Object[] arguments = new Object[aBlock.numArgs()];
			for (int j = 0; j < arguments.length; j++) {
				arguments[j] = anArray[j];
			}
			aBlock.valueWithArguments_(arguments);
		}
		return mobiusBody;
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param stripRadius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_stripRadius_(double mobiusRadius, double stripRadius) {
		return MobiusRadius_divisions_stripRadius_divisions_(mobiusRadius, 72, stripRadius, 8);
	}

	/**
	 * Typical object - mobius strip
	 * 
	 * @param mobiusRadius double
	 * @param stripRadius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusStrip() {
		return MobiusStripRadius_divisions_stripRadius_divisions_(3.0 / 4.0, 72, 1.0 / 4.0, 6);
	}

	/**
	 * Typical object - mobius strip
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param stripDivision int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusStripRadius_divisions_stripRadius_divisions_(double mobiusRadius, int mobiusDivision, double stripRadius, int stripDivision) {
		return MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(mobiusRadius, mobiusDivision, stripRadius, stripDivision, 0.001 * (mobiusRadius + stripRadius));
	}

	/**
	 * Typical object - mobius strip
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param stripDivision int
	 * @param thicknessFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(double mobiusRadius, int mobiusDivision, double stripRadius, final int stripDivision, final double thicknessFactor) {
		JunOpenGL3dCompoundObject compoundObject = (JunOpenGL3dCompoundObject) MobiusRadius_divisions_stripRadius_divisions_(mobiusRadius, mobiusDivision, stripRadius, stripDivision);
		final StValueHolder numberOfPolygonsHolder = new StValueHolder(0);
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				numberOfPolygonsHolder.value_(numberOfPolygonsHolder._intValue() + 1);
				return null;
			}
		});
		final int size = numberOfPolygonsHolder._intValue() / 2;
		final Set firstSetOfPolygons = new HashSet();
		final Set secondSetOfPolygons = new HashSet();
		final JunOpenGL3dCompoundObject mobiusStrip = new JunOpenGL3dCompoundObject();
		final JunGeometry.HashEqualityDictionary normalTable = new JunGeometry.HashEqualityDictionary();
		final JunGeometry.HashEqualityDictionary positiveTable = new JunGeometry.HashEqualityDictionary();
		final JunGeometry.HashEqualityDictionary negativeTable = new JunGeometry.HashEqualityDictionary();
		final StValueHolder countHolder = new StValueHolder(0);
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) obj;
				if (countHolder._intValue() < size) {
					Jun3dPoint aVector = aPolygon.normalUnitVector();
					Jun3dPoint[] vertexes = aPolygon.vertexes();
					for (int i = 0; i < vertexes.length; i++) {
						if (vertexes[i].x() > 0 && Math.abs(vertexes[i].y()) < JunGeometry.Accuracy() && Math.abs(vertexes[i].z()) < JunGeometry.Accuracy()) {
							if (JunPlane.Xy().whichSide_(aVector) >= 0) {
								if (positiveTable.containsKey(vertexes[i]) == false) {
									positiveTable.put(vertexes[i], new Jun3dPoint(0, 0, 1));
								}
							} else {
								if (negativeTable.containsKey(vertexes[i]) == false) {
									negativeTable.put(vertexes[i], new Jun3dPoint(0, 0, -1));
								}
							}
						} else {
							if (normalTable.containsKey(vertexes[i]) == false) {
								normalTable.put(vertexes[i], aVector);
							}
						}
					}
				}
				countHolder.value_(countHolder._intValue() + 1);
				return null;
			}
		});

		countHolder.value_(0);
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) obj;
				if (countHolder._intValue() < size) {
					Jun3dPoint aVector = aPolygon.normalUnitVector();
					Jun3dPoint[] vertexes = aPolygon.vertexes();
					Jun3dPoint[][] collectionOfPairs = new Jun3dPoint[vertexes.length][];
					for (int i = 0; i < vertexes.length; i++) {
						if (vertexes[i].x() > 0 && Math.abs(vertexes[i].y()) < JunGeometry.Accuracy() && Math.abs(vertexes[i].z()) < JunGeometry.Accuracy()) {
							if (JunPlane.Xy().whichSide_(aVector) >= 0) {
								aVector = (Jun3dPoint) positiveTable.get(vertexes[i]);
							} else {
								aVector = (Jun3dPoint) negativeTable.get(vertexes[i]);
							}
						} else {
							aVector = (Jun3dPoint) normalTable.get(vertexes[i]);
						}
						collectionOfPairs[i] = new Jun3dPoint[] { vertexes[i], aVector };
					}

					Jun3dPoint[] points = new Jun3dPoint[collectionOfPairs.length];
					for (int i = 0; i < collectionOfPairs.length; i++) {
						points[i] = collectionOfPairs[i][0].translatedBy_(collectionOfPairs[i][1].multipliedBy_(thicknessFactor));
					}
					JunOpenGL3dPolygon firstPolygon = new JunOpenGL3dPolygon(points);

					points = new Jun3dPoint[collectionOfPairs.length];
					for (int i = 0; i < collectionOfPairs.length; i++) {
						points[points.length - 1 - i] = collectionOfPairs[i][0].translatedBy_(collectionOfPairs[i][1].multipliedBy_(thicknessFactor).negated());
					}
					JunOpenGL3dPolygon secondPolygon = new JunOpenGL3dPolygon(points);

					mobiusStrip.add_(firstPolygon);
					mobiusStrip.add_(secondPolygon);
					firstSetOfPolygons.add(firstPolygon);
					firstSetOfPolygons.add(secondPolygon);

					if (countHolder._intValue() - (countHolder._intValue() / (stripDivision * 2)) * (stripDivision * 2) == 0) {
						JunOpenGL3dPolygon thirdPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { firstPolygon.vertexes()[1], firstPolygon.vertexes()[0], secondPolygon.vertexes()[2] });
						JunOpenGL3dPolygon forthPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { secondPolygon.vertexes()[2], secondPolygon.vertexes()[1], firstPolygon.vertexes()[1] });
						mobiusStrip.add_(thirdPolygon);
						mobiusStrip.add_(forthPolygon);
						secondSetOfPolygons.add(thirdPolygon);
						secondSetOfPolygons.add(forthPolygon);
					}
				}
				countHolder.value_(countHolder._intValue() + 1);
				return null;
			}
		});

		final JunGeometry.HashEqualityDictionary normalTable2 = new JunGeometry.HashEqualityDictionary();
		final JunGeometry.HashEqualityDictionary positiveTable2 = new JunGeometry.HashEqualityDictionary();
		final JunGeometry.HashEqualityDictionary negativeTable2 = new JunGeometry.HashEqualityDictionary();
		countHolder.value_(0);
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) obj;
				if (countHolder._intValue() >= size) {
					Jun3dPoint aVector = aPolygon.normalUnitVector();
					Jun3dPoint[] vertexes = aPolygon.vertexes();
					for (int i = 0; i < vertexes.length; i++) {
						if (vertexes[i].x() > 0 && Math.abs(vertexes[i].y()) < JunGeometry.Accuracy() && Math.abs(vertexes[i].z()) < JunGeometry.Accuracy()) {
							if (JunPlane.Xy().whichSide_(aVector) >= 0) {
								if (positiveTable2.containsKey(vertexes[i]) == false) {
									positiveTable2.put(vertexes[i], new Jun3dPoint(0, 0, 1));
								}
							} else {
								if (negativeTable2.containsKey(vertexes[i]) == false) {
									negativeTable2.put(vertexes[i], new Jun3dPoint(0, 0, -1));
								}
							}
						} else {
							if (normalTable2.containsKey(vertexes[i]) == false) {
								normalTable2.put(vertexes[i], aVector);
							}
						}
					}
				}
				countHolder.value_(countHolder._intValue() + 1);
				return null;
			}
		});

		countHolder.value_(0);
		compoundObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) obj;
				if (countHolder._intValue() >= size) {
					Jun3dPoint aVector = aPolygon.normalUnitVector();
					Jun3dPoint[] vertexes = aPolygon.vertexes();
					Jun3dPoint[][] collectionOfPairs = new Jun3dPoint[vertexes.length][];
					for (int i = 0; i < vertexes.length; i++) {
						if (vertexes[i].x() > 0 && Math.abs(vertexes[i].y()) < JunGeometry.Accuracy() && Math.abs(vertexes[i].z()) < JunGeometry.Accuracy()) {
							if (JunPlane.Xy().whichSide_(aVector) >= 0) {
								aVector = (Jun3dPoint) positiveTable2.get(vertexes[i]);
							} else {
								aVector = (Jun3dPoint) negativeTable2.get(vertexes[i]);
							}
						} else {
							aVector = (Jun3dPoint) normalTable2.get(vertexes[i]);
						}
						collectionOfPairs[i] = new Jun3dPoint[] { vertexes[i], aVector };
					}

					Jun3dPoint[] points = new Jun3dPoint[collectionOfPairs.length];
					for (int i = 0; i < collectionOfPairs.length; i++) {
						points[i] = collectionOfPairs[i][0].translatedBy_(collectionOfPairs[i][1].multipliedBy_(thicknessFactor));
					}
					JunOpenGL3dPolygon firstPolygon = new JunOpenGL3dPolygon(points);

					points = new Jun3dPoint[collectionOfPairs.length];
					for (int i = 0; i < collectionOfPairs.length; i++) {
						points[points.length - 1 - i] = collectionOfPairs[i][0].translatedBy_(collectionOfPairs[i][1].multipliedBy_(thicknessFactor).negated());
					}
					JunOpenGL3dPolygon secondPolygon = new JunOpenGL3dPolygon(points);

					mobiusStrip.add_(firstPolygon);
					mobiusStrip.add_(secondPolygon);
					firstSetOfPolygons.add(firstPolygon);
					firstSetOfPolygons.add(secondPolygon);

					if (countHolder._intValue() - (countHolder._intValue() / (stripDivision * 2)) * (stripDivision * 2) == 0) {
						JunOpenGL3dPolygon thirdPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { firstPolygon.vertexes()[1], firstPolygon.vertexes()[0], secondPolygon.vertexes()[2] });
						JunOpenGL3dPolygon forthPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { secondPolygon.vertexes()[2], secondPolygon.vertexes()[1], firstPolygon.vertexes()[1] });
						mobiusStrip.add_(thirdPolygon);
						mobiusStrip.add_(forthPolygon);
						secondSetOfPolygons.add(thirdPolygon);
						secondSetOfPolygons.add(forthPolygon);
					}
				}
				countHolder.value_(countHolder._intValue() + 1);
				return null;
			}
		});

		JunOpenGL3dPolygon[] polygons = (JunOpenGL3dPolygon[]) firstSetOfPolygons.toArray(new JunOpenGL3dPolygon[firstSetOfPolygons.size()]);
		JunGeometry.HashEqualityDictionary normalTable3 = NormalVectorTableOfPolygons_(polygons);
		for (int i = 0; i < polygons.length; i++) {
			Jun3dPoint[] vertexes = polygons[i].vertexes();
			Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
			for (int j = 0; j < vertexes.length; j++) {
				normalVectors[j] = (Jun3dPoint) normalTable3.get(vertexes[j]);
			}
			polygons[i].normalVectors_(normalVectors);
		}

		polygons = (JunOpenGL3dPolygon[]) secondSetOfPolygons.toArray(new JunOpenGL3dPolygon[secondSetOfPolygons.size()]);
		normalTable3 = NormalVectorTableOfPolygons_(polygons);
		for (int i = 0; i < polygons.length; i++) {
			Jun3dPoint[] vertexes = polygons[i].vertexes();
			Jun3dPoint[] normalVectors = new Jun3dPoint[vertexes.length];
			for (int j = 0; j < vertexes.length; j++) {
				normalVectors[j] = (Jun3dPoint) normalTable3.get(vertexes[j]);
			}
			polygons[i].normalVectors_(normalVectors);
		}

		mobiusStrip.name_("mobius strip");
		mobiusStrip.flushAllPaints();
		mobiusStrip.paint_(DefaultPaint());
		return mobiusStrip;
	}

	/**
	 * Answer the normal vector table of the specified polygons.
	 * 
	 * @param polygonCollection jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon[]
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry.JunHashEqualityDictionary
	 * @category Utilities
	 */
	public static JunGeometry.HashEqualityDictionary NormalVectorTableOfPolygons_(JunOpenGL3dPolygon[] polygonCollection) {
		JunGeometry.HashEqualityDictionary normalVectorsTable = new JunGeometry.HashEqualityDictionary();
		for (int i = 0; i < polygonCollection.length; i++) {
			Jun3dPoint vector = polygonCollection[i].normalUnitVector();
			Jun3dPoint[] vertexes = polygonCollection[i].vertexes();
			for (int j = 0; j < vertexes.length; j++) {
				if (normalVectorsTable.containsKey(vertexes[j]) == false) {
					normalVectorsTable.put(vertexes[j], new ArrayList());
				}
				((ArrayList) normalVectorsTable.get(vertexes[j])).add(vector);
			}
		}
		JunGeometry.HashEqualityDictionary normalVectorTableOfPolygons = new JunGeometry.HashEqualityDictionary();
		Jun3dPoint[] keys = (Jun3dPoint[]) normalVectorsTable.keySet().toArray(new Jun3dPoint[normalVectorsTable.size()]);
		for (int i = 0; i < keys.length; i++) {
			Jun3dPoint key = keys[i];
			ArrayList value = (ArrayList) normalVectorsTable.get(key);
			Jun3dPoint[] vectors = (Jun3dPoint[]) value.toArray(new Jun3dPoint[value.size()]);
			Jun3dPoint total = new Jun3dPoint(0, 0, 0);
			for (int j = 0; j < vectors.length; j++) {
				total = total.plus_(vectors[j]);
			}
			normalVectorTableOfPolygons.put(key, total.dividedBy_(vectors.length).normalUnitVector());
		}
		return normalVectorTableOfPolygons;
	}
}
